/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.effect.EffectWithNoCounter;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffectInstance;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import org.jetbrains.annotations.NotNull;

public class SanguinareEffect
extends VampirismEffect
implements EffectWithNoCounter {
    public static void addRandom(@NotNull LivingEntity entity, boolean player) {
        int avgDuration = 20 * (player ? (Integer)VampirismConfig.BALANCE.vpSanguinareAverageDuration.get() : BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        int duration = (int)((entity.m_217043_().m_188501_() + 0.5f) * (float)avgDuration);
        SanguinareEffectInstance effect = new SanguinareEffectInstance(duration);
        Preconditions.checkNotNull((Object)((Object)effect));
        if (!((Boolean)VampirismConfig.BALANCE.canCancelSanguinare.get()).booleanValue()) {
            effect.setCurativeItems(new ArrayList());
        }
        entity.m_7292_((MobEffectInstance)effect);
    }

    public SanguinareEffect(@NotNull MobEffectCategory effectType, int potionColor) {
        super(effectType, potionColor);
        this.m_19472_(Attributes.f_22281_, "22663B89-116E-49DC-9B6B-9971489B5BE5", 2.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    @NotNull
    public List<ItemStack> getCurativeItems() {
        List<ItemStack> l = super.getCurativeItems();
        l.add(new ItemStack((ItemLike)ModItems.GARLIC_BREAD.get()));
        return l;
    }

    @Override
    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        if (entity.f_19853_.f_46443_ || !entity.m_6084_()) {
            return;
        }
        if (entity instanceof PathfinderMob) {
            ExtendedCreature.getSafe((Entity)entity).ifPresent(IExtendedCreatureVampirism::makeVampire);
        }
        if (entity instanceof Player) {
            VampirePlayer.getOpt((Player)entity).ifPresent(VampirePlayer::onSanguinareFinished);
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return duration == 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInGui(MobEffectInstance instance) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, PoseStack poseStack, int x, int y, int blitOffset) {
                Component component = screen.m_194000_(instance);
                screen.f_96547_.m_92763_(poseStack, component, (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
                screen.f_96547_.m_92750_(poseStack, "**:**", (float)(x + 10 + 18), (float)(y + 6 + 10), 0x7F7F7F);
                return true;
            }
        });
    }
}

