/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.util.DamageHandler;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import org.jetbrains.annotations.NotNull;

public class VampirismPoisonEffect
extends VampirismEffect {
    public static final int DEADLY_AMPLIFIER = 4;

    public VampirismPoisonEffect(int potionColor) {
        super(MobEffectCategory.HARMFUL, potionColor);
    }

    @Override
    public void m_6742_(@NotNull LivingEntity entityLivingBaseIn, int amplifier) {
        float damage;
        float f = damage = amplifier >= 4 ? (float)amplifier : Math.min(entityLivingBaseIn.m_21223_() - 1.0f, (float)amplifier);
        if (damage > 0.0f) {
            DamageHandler.hurtVanilla((Entity)entityLivingBaseIn, DamageSources::m_269425_, damage);
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        int j = 25 >> amplifier;
        if (j > 0) {
            return duration % j == 0;
        }
        return true;
    }

    public void initializeClient(@NotNull Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, PoseStack poseStack, int x, int y, int blitOffset) {
                MutableComponent component = ((MutableComponent)screen.m_194000_(instance)).m_130946_(" - ").m_7220_(MobEffectUtil.m_267641_((MobEffectInstance)instance, (float)1.0f));
                screen.f_96547_.m_92763_(poseStack, (Component)component, (float)(x + 10 + 18), (float)(y + 6), 0xFFFFFF);
                MutableComponent note = Component.m_237115_((String)"effect.vampirism.wrong_equipment.note").m_130940_(ChatFormatting.DARK_RED);
                screen.f_96547_.m_92763_(poseStack, (Component)note, (float)(x + 10 + 18), (float)(y + 6 + 10), -1);
                return true;
            }
        });
    }
}

