/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.Helper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SundamageRegistry
implements ISundamageRegistry {
    private static final Logger LOGGER = LogManager.getLogger(SundamageRegistry.class);
    private final HashMap<ResourceKey<Level>, Boolean> sundamageDims = new HashMap();
    private final HashMap<ResourceKey<Level>, Boolean> sundamageConfiguredDims = new HashMap();
    private final Set<ResourceLocation> noSundamageBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();
    private final Set<ResourceLocation> noSundamageConfiguredBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();

    public SundamageRegistry() {
        this.sundamageDims.put((ResourceKey<Level>)Level.f_46428_, true);
        this.sundamageDims.put((ResourceKey<Level>)Level.f_46429_, false);
        this.sundamageDims.put((ResourceKey<Level>)Level.f_46430_, false);
    }

    public void addNoSundamageBiomeConfigured(ResourceLocation id) {
        this.noSundamageConfiguredBiomesIDs.add(id);
    }

    @Override
    public void addNoSundamageBiomes(ResourceLocation ... biomes) {
        this.noSundamageBiomesIDs.addAll(Arrays.asList(biomes));
    }

    @Override
    @Deprecated
    public boolean getSundamageInBiome(ResourceLocation registryName) {
        return !this.noSundamageBiomesIDs.contains(registryName) && !this.noSundamageConfiguredBiomesIDs.contains(registryName);
    }

    @Override
    public boolean getSundamageInDim(ResourceKey<Level> dim) {
        Boolean r = this.sundamageConfiguredDims.get(dim);
        if (r == null) {
            r = this.sundamageDims.get(dim);
        }
        return r == null ? (Boolean)VampirismConfig.SERVER.sundamageUnknownDimension.get() : r;
    }

    @Override
    public boolean isGettingSundamage(LivingEntity entity, LevelAccessor world) {
        return Helper.gettingSundamge(entity, world, null);
    }

    public void reloadConfiguration() {
        this.sundamageConfiguredDims.clear();
        List negative = (List)VampirismConfig.SERVER.sundamageDimensionsOverrideNegative.get();
        for (Object s : negative) {
            ResourceLocation id = new ResourceLocation((String)s);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id);
            this.sundamageConfiguredDims.put((ResourceKey<Level>)key, false);
        }
        List positive = (List)VampirismConfig.SERVER.sundamageDimensionsOverridePositive.get();
        for (String s : positive) {
            ResourceLocation id = new ResourceLocation(s);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id);
            this.sundamageConfiguredDims.put((ResourceKey<Level>)key, true);
        }
        this.noSundamageConfiguredBiomesIDs.clear();
        List biomes = (List)VampirismConfig.SERVER.sundamageDisabledBiomes.get();
        for (String s : biomes) {
            ResourceLocation id = new ResourceLocation(s);
            this.noSundamageConfiguredBiomesIDs.add(id);
        }
    }

    public void specifyConfiguredSundamageForDim(ResourceKey<Level> dimension, boolean sundamage) {
        this.sundamageConfiguredDims.put(dimension, sundamage);
    }

    @Override
    public void specifySundamageForDim(ResourceKey<Level> dimension, boolean sundamage) {
        this.sundamageDims.put(dimension, sundamage);
    }
}

