/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.ai.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.mixin.WalkAnimationStateAccessor;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertedCreatureEntity<T extends PathfinderMob>
extends VampireBaseEntity
implements ICurableConvertedCreature<T>,
ISyncable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(ConvertedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private T entityCreature;
    private boolean entityChanged = false;
    private boolean canDespawn = false;
    @Nullable
    private Component name;
    private int conversionTime;
    @Nullable
    private UUID conversationStarter;

    public static boolean spawnPredicate(EntityType<? extends ConvertedCreatureEntity<?>> entityType, @NotNull LevelAccessor iWorld, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return (iWorld.m_8055_(blockPos.m_7495_()).m_60734_() == Blocks.f_50440_ || iWorld.m_8055_(blockPos.m_7495_()).m_204336_(ModTags.Blocks.CURSED_EARTH)) && iWorld.m_45524_(blockPos, 0) > 8;
    }

    public ConvertedCreatureEntity(EntityType<? extends ConvertedCreatureEntity> type, Level world) {
        super(type, world, false);
        this.enableImobConversion();
        this.f_21364_ = 2;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        this.writeOldEntityToNBT(nbt);
        nbt.m_128379_("converter_canDespawn", this.canDespawn);
        nbt.m_128405_("ConversionTime", this.isConverting(this) ? this.conversionTime : -1);
        if (this.conversationStarter != null) {
            nbt.m_128362_("ConversionPlayer", this.conversationStarter);
        }
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.isConverting(this)) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                this.conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)this.f_19853_, this, this.entityCreature.m_6095_());
            }
        }
        super.m_8107_();
    }

    @Override
    public T createCuredEntity(PathfinderMob entity, EntityType<T> newType) {
        this.entityCreature.revive();
        return this.entityCreature;
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.nil()) {
            this.entityCreature.m_20359_((Entity)this);
            ((PathfinderMob)this.entityCreature).f_19856_ = this.f_19856_;
            ((PathfinderMob)this.entityCreature).f_19855_ = this.f_19855_;
            ((PathfinderMob)this.entityCreature).f_19854_ = this.f_19854_;
            ((PathfinderMob)this.entityCreature).f_20885_ = this.f_20885_;
            ((PathfinderMob)this.entityCreature).f_19860_ = this.f_19860_;
            ((PathfinderMob)this.entityCreature).f_19859_ = this.f_19859_;
            ((PathfinderMob)this.entityCreature).f_20886_ = this.f_20886_;
            this.entityCreature.m_20256_(this.m_20184_());
            ((PathfinderMob)this.entityCreature).f_19790_ = this.f_19790_;
            ((PathfinderMob)this.entityCreature).f_19791_ = this.f_19791_;
            ((PathfinderMob)this.entityCreature).f_19792_ = this.f_19792_;
            ((PathfinderMob)this.entityCreature).f_20916_ = this.f_20916_;
            ((PathfinderMob)this.entityCreature).f_20917_ = this.f_20917_;
            ((PathfinderMob)this.entityCreature).f_20921_ = this.f_20921_;
            ((PathfinderMob)this.entityCreature).f_20920_ = this.f_20920_;
            ((WalkAnimationStateAccessor)((PathfinderMob)this.entityCreature).f_267362_).setSpeed(((WalkAnimationStateAccessor)this.f_267362_).getSpeed());
            ((WalkAnimationStateAccessor)((PathfinderMob)this.entityCreature).f_267362_).setSpeedOld(((WalkAnimationStateAccessor)this.f_267362_).getSpeedOld());
            ((WalkAnimationStateAccessor)((PathfinderMob)this.entityCreature).f_267362_).setPosition(((WalkAnimationStateAccessor)this.f_267362_).getPosition());
            ((PathfinderMob)this.entityCreature).f_20883_ = this.f_20883_;
            ((PathfinderMob)this.entityCreature).f_20884_ = this.f_20884_;
            ((PathfinderMob)this.entityCreature).f_20919_ = this.f_20919_;
        }
        if (this.entityChanged) {
            this.updateEntityAttributes();
            this.entityChanged = false;
        }
    }

    @Override
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @NotNull
    protected Component m_5677_() {
        if (this.name == null) {
            this.name = Component.m_237115_((String)"entity.vampirism.vampire").m_130946_(" ").m_7220_(this.nil() ? super.m_5677_() : this.entityCreature.m_7755_());
        }
        return this.name;
    }

    public T getOldCreature() {
        return this.entityCreature;
    }

    public void m_7822_(byte id) {
        if (!this.handleSound(id, this)) {
            super.m_7822_(id);
        }
    }

    @Override
    public void loadUpdateFromNBT(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("entity_old")) {
            this.setEntityCreature(EntityType.m_20642_((CompoundTag)nbt.m_128469_("entity_old"), (Level)this.m_20193_()).orElse(null));
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("entity_old")) {
            this.setEntityCreature(EntityType.m_20642_((CompoundTag)nbt.m_128469_("entity_old"), (Level)this.f_19853_).orElse(null));
            if (this.nil()) {
                LOGGER.warn("Failed to create old entity {}. Maybe the entity does not exist anymore", (Object)nbt.m_128469_("entity_old"));
            }
        } else {
            LOGGER.warn("Saved entity did not have a old entity");
        }
        if (nbt.m_128441_("converted_canDespawn")) {
            this.canDespawn = nbt.m_128471_("converted_canDespawn");
        }
        if (nbt.m_128425_("ConversionTime", 99) && nbt.m_128451_("ConversionTime") > -1) {
            this.startConverting(nbt.m_128403_("ConversionPlayer") ? nbt.m_128342_("ConversionPlayer") : null, nbt.m_128451_("ConversionTime"), this);
        }
    }

    public void m_8032_() {
        if (!this.nil()) {
            this.entityCreature.m_8032_();
        }
    }

    public void m_6210_() {
        super.m_6210_();
        this.f_19816_ = this.entityCreature == null ? 0.5f : this.entityCreature.m_20192_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return super.m_6785_(distanceToClosestPlayer) && this.canDespawn;
    }

    public void setCanDespawn() {
        this.canDespawn = true;
    }

    public void setEntityCreature(@Nullable T creature) {
        if (creature == null && this.entityCreature != null) {
            this.entityChanged = true;
            this.entityCreature = null;
        } else if (creature != null && !creature.equals(this.entityCreature)) {
            this.entityCreature = creature;
            this.entityChanged = true;
            this.f_19815_ = ((PathfinderMob)creature).f_19815_;
        }
        if (this.entityCreature != null && this.getConvertedHelper() == null) {
            LOGGER.warn("Cannot find converting handler for converted creature {} ({})", (Object)this, this.entityCreature);
            this.entityCreature = null;
        }
    }

    @Override
    public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @NotNull PathfinderMob entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        this.conversationStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
    }

    @Nullable
    public ItemEntity m_5552_(@NotNull ItemStack stack, float offsetY) {
        ItemStack actualDrop = stack;
        Item item = stack.m_41720_();
        if (item.m_41472_() && item.getFoodProperties(stack, (LivingEntity)this).m_38746_()) {
            actualDrop = new ItemStack((ItemLike)Items.f_42583_, stack.m_41613_());
        }
        return super.m_5552_(actualDrop, offsetY);
    }

    @NotNull
    public String toString() {
        return "[" + super.toString() + " representing " + this.entityCreature + "]";
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.entityCreature == null) {
            LOGGER.debug("Setting dead, since creature is null");
            this.m_146870_();
        }
    }

    @Override
    public void writeFullUpdateToNBT(@NotNull CompoundTag nbt) {
        this.writeOldEntityToNBT(nbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerConvertingData(this);
    }

    @Nullable
    protected IConvertingHandler.IDefaultHelper getConvertedHelper() {
        if (this.nil()) {
            return null;
        }
        BiteableEntry biteableEntry = VampirismAPI.entityRegistry().getEntry((PathfinderMob)this.entityCreature);
        if (biteableEntry == null) {
            LOGGER.warn("Cannot find biteable entry for {}", this.entityCreature);
            return null;
        }
        IConvertingHandler<?> handler = biteableEntry.convertingHandler;
        if (handler instanceof DefaultConvertingHandler) {
            return ((DefaultConvertingHandler)handler).getHelper();
        }
        return null;
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.CONVERTED_CREATURE_IMOB.get() : (EntityType)ModEntities.CONVERTED_CREATURE.get();
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        if (this.entityCreature != null) {
            return this.entityCreature.m_5743_();
        }
        return super.m_7582_();
    }

    protected boolean nil() {
        return this.entityCreature == null;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42436_) {
            return this.interactWithCureItem(player, stack, this);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        this.f_21345_.m_25352_(4, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(5, (Goal)new AttackMeleeNoSunGoal(this, 0.9, false));
        this.f_21364_ = 2;
        this.f_21345_.m_25352_(11, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(13, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(15, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }

    protected void updateEntityAttributes() {
        IConvertingHandler.IDefaultHelper helper = this.getConvertedHelper();
        try {
            if (helper != null) {
                this.m_21051_(Attributes.f_22281_).m_22100_(helper.getConvertedDMG((EntityType<? extends PathfinderMob>)this.entityCreature.m_6095_()));
                this.m_21051_(Attributes.f_22276_).m_22100_(helper.getConvertedMaxHealth((EntityType<? extends PathfinderMob>)this.entityCreature.m_6095_()));
                this.m_21051_(Attributes.f_22278_).m_22100_(helper.getConvertedKnockbackResistance((EntityType<? extends PathfinderMob>)this.entityCreature.m_6095_()));
                this.m_21051_(Attributes.f_22279_).m_22100_(helper.getConvertedSpeed((EntityType<? extends PathfinderMob>)this.entityCreature.m_6095_()));
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(0.0);
                this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            }
        }
        catch (NullPointerException e) {
            LOGGER.error("Failed to update entity attributes for {} {}", (Object)this, (Object)e);
        }
    }

    private void writeOldEntityToNBT(@NotNull CompoundTag nbt) {
        if (!this.nil()) {
            try {
                CompoundTag entity = new CompoundTag();
                this.entityCreature.revive();
                this.entityCreature.m_20223_(entity);
                this.entityCreature.m_146870_();
                nbt.m_128365_("entity_old", (Tag)entity);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to write old entity (%s) to NBT. If this happens more often please report this to the mod author.", this.entityCreature), (Throwable)e);
                this.setEntityCreature(null);
            }
        }
    }

    @Override
    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    public static class IMob
    extends ConvertedCreatureEntity
    implements Enemy {
        public IMob(EntityType<? extends ConvertedCreatureEntity> type, Level world) {
            super(type, world);
        }
    }
}

