/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;

public class PlayableFaction<T extends IFactionPlayer<T>>
extends Faction<T>
implements IPlayableFaction<T> {
    private final int highestLevel;
    private final int highestLordLevel;
    private final NonNullSupplier<Capability<T>> playerCapabilitySupplier;
    private final BiFunction<Integer, Boolean, Component> lordTitleFunction;
    private final Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot;
    private final boolean hasLordSkills;

    PlayableFaction(@NotNull FactionRegistry.PlayableFactionBuilder<T> builder) {
        super(builder);
        this.highestLevel = builder.highestLevel;
        this.highestLordLevel = builder.highestLordLevel;
        this.playerCapabilitySupplier = builder.playerCapabilitySupplier;
        this.lordTitleFunction = builder.lordTitleFunction;
        this.refinementItemBySlot = builder.refinementItemBySlot;
        this.hasLordSkills = builder.hasLordSkills;
    }

    @Override
    public Class<T> getFactionPlayerInterface() {
        return super.getFactionEntityInterface();
    }

    @Override
    public int getHighestLordLevel() {
        return this.highestLordLevel;
    }

    @Override
    public int getHighestReachableLevel() {
        return this.highestLevel;
    }

    @Override
    public boolean hasLordSkills() {
        return this.hasLordSkills;
    }

    @Override
    @NotNull
    public Component getLordTitle(int level, boolean female) {
        assert (level <= this.highestLordLevel);
        return this.lordTitleFunction.apply(level, female);
    }

    @Override
    @NotNull
    public LazyOptional<T> getPlayerCapability(@NotNull Player player) {
        return player.getCapability((Capability)this.playerCapabilitySupplier.get(), null);
    }

    @Override
    public boolean hasRefinements() {
        return this.refinementItemBySlot != null;
    }

    @Override
    public <Z extends Item> Z getRefinementItem(IRefinementItem.AccessorySlotType type) {
        assert (this.refinementItemBySlot != null);
        return (Z)((Item)this.refinementItemBySlot.apply(type));
    }

    @Override
    @NotNull
    public String toString() {
        return "PlayableFaction{id='" + this.id + "'}";
    }
}

