/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionData;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.ILordPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultMinionTask<T extends IMinionTask.IMinionTaskDesc<Q>, Q extends IMinionData>
implements IMinionTask<T, Q> {
    private Component name;
    private final Supplier<? extends ISkill<?>> requiredSkill;

    public DefaultMinionTask() {
        this(() -> null);
    }

    public DefaultMinionTask(Supplier<? extends ISkill<?>> requiredSkill) {
        this.requiredSkill = requiredSkill;
    }

    @Override
    @Nullable
    public T activateTask(@Nullable Player lord, @Nullable IMinionEntity minion, Q data) {
        this.triggerAdvancements(lord);
        return null;
    }

    @Override
    @NotNull
    public Component getName() {
        if (this.name == null) {
            this.name = Component.m_237115_((String)Util.m_137492_((String)"minion_task", (ResourceLocation)RegUtil.id(this)));
        }
        return this.name;
    }

    protected void triggerAdvancements(Player player) {
        if (player instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_MINION_ACTION.trigger((ServerPlayer)player, this);
        }
    }

    public boolean isRequiredSkillUnlocked(@NotNull IPlayableFaction<?> faction, @Nullable ILordPlayer player) {
        return this.requiredSkill.get() == null || player == null || faction.getPlayerCapability(player.getPlayer()).map(a -> a.getSkillHandler().isSkillEnabled(this.requiredSkill.get())).orElse(false) != false;
    }
}

