/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.player.TaskManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FactionBasePlayer<T extends IFactionPlayer<T>>
implements IFactionPlayer<T>,
ISyncable.ISyncableEntityCapabilityInst,
IPlayerEventListener {
    private static final Logger LOGGER = LogManager.getLogger(FactionBasePlayer.class);
    protected final Player player;
    @Nullable
    private final TaskManager taskManager;

    public FactionBasePlayer(Player player) {
        this.player = player;
        this.taskManager = player instanceof ServerPlayer ? new TaskManager((ServerPlayer)player, this, (IPlayableFaction<?>)this.getFaction()) : null;
    }

    @Override
    public int getLevel() {
        return VampirismAPI.getFactionPlayerHandler(this.player).map(handler -> handler.getCurrentLevel((IPlayableFaction<?>)this.getFaction())).orElse(0);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this.player;
    }

    @Override
    public Player getRepresentingPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public int getTheEntityID() {
        return this.player.m_19879_();
    }

    @Override
    public boolean isRemote() {
        if (this.player.m_20193_() == null) {
            LOGGER.error("Trying to check if remote, but world is not set yet", new Throwable("World not loaded").fillInStackTrace());
            return false;
        }
        return this.player.m_20193_().f_46443_;
    }

    public void loadData(@NotNull CompoundTag nbt) {
        if (this.taskManager != null) {
            this.taskManager.readNBT(nbt);
        } else {
            LOGGER.debug("The player is loaded on the client side and therefore taskmaster related data is missing");
        }
    }

    @Override
    public final void loadUpdateFromNBT(CompoundTag nbt) {
        this.loadUpdate(nbt);
    }

    @Override
    public void onDeath(DamageSource src) {
        this.getSkillHandler().damageRefinements();
    }

    @Override
    public void onPlayerClone(@NotNull Player original, boolean wasDeath) {
        original.reviveCaps();
        this.copyFromPlayer(original);
        original.invalidateCaps();
    }

    @Override
    public void onUpdate() {
        if (!this.isRemote()) {
            this.taskManager.tick();
        }
    }

    public void saveData(@NotNull CompoundTag nbt) {
        if (this.taskManager != null) {
            this.taskManager.writeNBT(nbt);
        } else {
            LOGGER.debug("The player is saved on the client side and therefore taskmaster related data is missing");
        }
    }

    public void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    @Override
    public final void writeFullUpdateToNBT(CompoundTag nbt) {
        this.writeFullUpdate(nbt);
    }

    protected abstract FactionBasePlayer<T> copyFromPlayer(Player var1);

    protected void loadUpdate(CompoundTag nbt) {
    }

    protected void sync(@NotNull CompoundTag data, boolean all) {
        HelperLib.sync(this, data, (Entity)this.player, all);
    }

    protected void writeFullUpdate(CompoundTag nbt) {
    }
}

