/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.hunter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class HunterLevelingConf {
    private static final Logger LOGGER = LogManager.getLogger(HunterLevelingConf.class);
    private static HunterLevelingConf instance;
    public final int BASIC_HUNTER_MIN_LEVEL = 2;
    public final int BASIC_HUNTER_MAX_LEVEL = 4;
    public final int TABLE_MIN_LEVEL = 5;
    public final int TABLE_MAX_LEVEL = 14;
    public final int HUNTER_INTEL_COUNT = 10;

    @NotNull
    public static HunterLevelingConf instance() {
        if (instance == null) {
            instance = new HunterLevelingConf();
        }
        return instance;
    }

    public int getHunterIntelMetaForLevel(int level) {
        return this.isLevelValidForTable(level) ? level - 5 : -1;
    }

    public int[] getItemRequirementsForTable(int targetLevel) {
        int[] nArray;
        if (!this.isLevelValidForTable(targetLevel)) {
            throw new IllegalArgumentException("Cannot use the table with the given target level " + targetLevel);
        }
        switch (targetLevel) {
            case 5: {
                int[] nArray2 = new int[4];
                nArray2[0] = 10;
                nArray2[1] = 0;
                nArray2[2] = 0;
                nArray = nArray2;
                nArray2[3] = 1;
                break;
            }
            case 6: {
                int[] nArray3 = new int[4];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray3[2] = 0;
                nArray = nArray3;
                nArray3[3] = 1;
                break;
            }
            case 7: {
                int[] nArray4 = new int[4];
                nArray4[0] = 10;
                nArray4[1] = 1;
                nArray4[2] = 0;
                nArray = nArray4;
                nArray4[3] = 1;
                break;
            }
            case 8: {
                int[] nArray5 = new int[4];
                nArray5[0] = 0;
                nArray5[1] = 1;
                nArray5[2] = 1;
                nArray = nArray5;
                nArray5[3] = 1;
                break;
            }
            case 9: {
                int[] nArray6 = new int[4];
                nArray6[0] = 15;
                nArray6[1] = 1;
                nArray6[2] = 1;
                nArray = nArray6;
                nArray6[3] = 1;
                break;
            }
            case 10: 
            case 11: {
                int[] nArray7 = new int[4];
                nArray7[0] = 20;
                nArray7[1] = 1;
                nArray7[2] = 2;
                nArray = nArray7;
                nArray7[3] = 1;
                break;
            }
            case 12: {
                int[] nArray8 = new int[4];
                nArray8[0] = 20;
                nArray8[1] = 1;
                nArray8[2] = 3;
                nArray = nArray8;
                nArray8[3] = 1;
                break;
            }
            case 13: {
                int[] nArray9 = new int[4];
                nArray9[0] = 25;
                nArray9[1] = 2;
                nArray9[2] = 3;
                nArray = nArray9;
                nArray9[3] = 1;
                break;
            }
            case 14: {
                int[] nArray10 = new int[4];
                nArray10[0] = 25;
                nArray10[1] = 2;
                nArray10[2] = 4;
                nArray = nArray10;
                nArray10[3] = 1;
                break;
            }
            default: {
                nArray = null;
            }
        }
        return nArray;
    }

    public int[] getItemRequirementsForTrainer(int targetLevel) {
        int[] nArray;
        if (this.isLevelValidForTrainer(targetLevel) != 0) {
            throw new IllegalArgumentException("Cannot use the trainer with the given target level " + targetLevel);
        }
        switch (targetLevel) {
            case 5: {
                int[] nArray2 = new int[2];
                nArray2[0] = 5;
                nArray = nArray2;
                nArray2[1] = 0;
                break;
            }
            case 6: {
                int[] nArray3 = new int[2];
                nArray3[0] = 10;
                nArray = nArray3;
                nArray3[1] = 0;
                break;
            }
            case 7: {
                int[] nArray4 = new int[2];
                nArray4[0] = 15;
                nArray = nArray4;
                nArray4[1] = 0;
                break;
            }
            case 8: {
                int[] nArray5 = new int[2];
                nArray5[0] = 40;
                nArray = nArray5;
                nArray5[1] = 0;
                break;
            }
            case 9: 
            case 11: {
                int[] nArray6 = new int[2];
                nArray6[0] = 20;
                nArray = nArray6;
                nArray6[1] = 10;
                break;
            }
            case 10: {
                int[] nArray7 = new int[2];
                nArray7[0] = 20;
                nArray = nArray7;
                nArray7[1] = 20;
                break;
            }
            case 12: {
                int[] nArray8 = new int[2];
                nArray8[0] = 30;
                nArray = nArray8;
                nArray8[1] = 10;
                break;
            }
            case 13: {
                int[] nArray9 = new int[2];
                nArray9[0] = 40;
                nArray = nArray9;
                nArray9[1] = 20;
                break;
            }
            case 14: {
                int[] nArray10 = new int[2];
                nArray10[0] = 40;
                nArray = nArray10;
                nArray10[1] = 40;
                break;
            }
            default: {
                LOGGER.warn("Something is wrong with the hunter levels");
                nArray = null;
            }
        }
        return nArray;
    }

    public int getLevelForHunterIntelMeta(int meta) {
        return Math.min(meta + 5, 14);
    }

    public int getVampireBloodCountForBasicHunter(int targetLevel) {
        if (!this.isLevelValidForBasicHunter(targetLevel)) {
            throw new IllegalArgumentException("Cannot use the table with the given target level " + targetLevel);
        }
        return switch (targetLevel) {
            case 2 -> 1;
            case 3 -> 5;
            case 4 -> 12;
            default -> 100000;
        };
    }

    public boolean isLevelValidForBasicHunter(int targetLevel) {
        return targetLevel >= 2 && targetLevel <= 4;
    }

    public boolean isLevelValidForTable(int targetLevel) {
        return targetLevel >= 5 && targetLevel <= 14;
    }

    public boolean isLevelValidForTableTier(int targetLevel, int tier) {
        return !(!this.isLevelValidForTable(targetLevel) || targetLevel > 11 && tier < 3 || targetLevel > 9 && tier < 2 || targetLevel > 7 && tier < 1);
    }

    public int isLevelValidForTrainer(int targetLevel) {
        return targetLevel >= 5 ? (targetLevel <= 14 ? 0 : 1) : -1;
    }
}

