/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.hunter.skills;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.VampirismSkill;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class HunterSkills {
    public static final DeferredRegister<ISkill<?>> SKILLS = DeferredRegister.create(VampirismRegistries.SKILLS_ID, (String)"vampirism");
    public static final RegistryObject<ISkill<IHunterPlayer>> BASIC_ALCHEMY = SKILLS.register("basic_alchemy", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> DOUBLE_CROSSBOW = SKILLS.register("double_crossbow", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> ENHANCED_ARMOR = SKILLS.register("enhanced_armor", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> ENHANCED_WEAPONS = SKILLS.register("enhanced_weapons", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> GARLIC_DIFFUSER = SKILLS.register("garlic_diffuser", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> GARLIC_DIFFUSER_IMPROVED = SKILLS.register("garlic_diffuser_improved", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> ENHANCED_BLESSING = SKILLS.register("enhanced_blessing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> HUNTER_ATTACK_SPEED = SKILLS.register("hunter_attack_speed", () -> new VampirismSkill.SimpleHunterSkill(false).registerAttributeModifier(Attributes.f_22283_, "8dd2f8cc-6ae1-4db1-9e14-96b4c74d7bf2", () -> (Double)VampirismConfig.BALANCE.hsSmallAttackSpeedModifier.get(), AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<ISkill<IHunterPlayer>> HUNTER_ATTACK_SPEED_ADVANCED = SKILLS.register("hunter_attack_speed_advanced", () -> new VampirismSkill.SimpleHunterSkill(true).registerAttributeModifier(Attributes.f_22283_, "d9311f44-a4ba-4ef4-83f2-9274ae1a827e", () -> (Double)VampirismConfig.BALANCE.hsMajorAttackSpeedModifier.get(), AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<ISkill<IHunterPlayer>> HUNTER_ATTACK_DAMAGE = SKILLS.register("hunter_attack_damage", () -> new VampirismSkill.SimpleHunterSkill(false).registerAttributeModifier(Attributes.f_22281_, "ffafd115-96e2-4d08-9588-d1bc9be0d902", () -> (Double)VampirismConfig.BALANCE.hsSmallAttackDamageModifier.get(), AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<ISkill<IHunterPlayer>> HUNTER_AWARENESS = SKILLS.register("hunter_awareness", () -> new ActionSkill(HunterActions.AWARENESS_HUNTER, true));
    public static final RegistryObject<ISkill<IHunterPlayer>> HUNTER_DISGUISE = SKILLS.register("hunter_disguise", () -> new ActionSkill(HunterActions.DISGUISE_HUNTER, true));
    public static final RegistryObject<ISkill<IHunterPlayer>> PURIFIED_GARLIC = SKILLS.register("purified_garlic", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> STAKE1 = SKILLS.register("stake1", () -> new VampirismSkill.SimpleHunterSkill(false).setDescription(() -> {
        MutableComponent desc = Component.m_237110_((String)"skill.vampirism.stake1.desc", (Object[])new Object[]{(int)((Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * 100.0)});
        if (((Boolean)VampirismConfig.BALANCE.hsInstantKill1FromBehind.get()).booleanValue()) {
            desc.m_7220_((Component)Component.m_237113_((String)" "));
            desc.m_7220_((Component)Component.m_237115_((String)"text.vampirism.from_behind"));
        }
        return desc;
    }));
    public static final RegistryObject<ISkill<IHunterPlayer>> STAKE2 = SKILLS.register("stake2", () -> new VampirismSkill.SimpleHunterSkill(false).setDescription(() -> {
        MutableComponent desc = (Boolean)VampirismConfig.BALANCE.hsInstantKill2OnlyNPC.get() != false ? Component.m_237110_((String)"skill.vampirism.stake2.desc_npc", (Object[])new Object[]{VampirismConfig.BALANCE.hsInstantKill2MaxHealth.get()}) : Component.m_237110_((String)"skill.vampirism.stake2.desc_all", (Object[])new Object[]{VampirismConfig.BALANCE.hsInstantKill2MaxHealth.get()});
        return desc;
    }));
    public static final RegistryObject<ISkill<IHunterPlayer>> TECH_WEAPONS = SKILLS.register("tech_weapons", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> WEAPON_TABLE = SKILLS.register("weapon_table", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> DURABLE_BREWING = SKILLS.register("durable_brewing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> CONCENTRATED_BREWING = SKILLS.register("concentrated_brewing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> MULTITASK_BREWING = SKILLS.register("multitask_brewing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> EFFICIENT_BREWING = SKILLS.register("efficient_brewing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> MASTER_BREWER = SKILLS.register("master_brewer", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> SWIFT_BREWING = SKILLS.register("swift_brewing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> CONCENTRATED_DURABLE_BREWING = SKILLS.register("concentrated_durable_brewing", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> POTION_RESISTANCE = SKILLS.register("potion_resistance", () -> new ActionSkill(HunterActions.POTION_RESISTANCE_HUNTER, true));
    public static final RegistryObject<ISkill<IHunterPlayer>> CRUCIFIX_WIELDER = SKILLS.register("crucifix_wielder", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> ULTIMATE_CRUCIFIX = SKILLS.register("ultimate_crucifix", () -> new VampirismSkill.SimpleHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> MINION_COLLECT = SKILLS.register("hunter_minion_collect", () -> new VampirismSkill.LordHunterSkill(true));
    public static final RegistryObject<ISkill<IHunterPlayer>> MINION_STATS_INCREASE = SKILLS.register("hunter_minion_stats_increase", () -> new VampirismSkill.LordHunterSkill(true).setToggleActions(hunter -> hunter.updateMinionAttributes(true), hunter -> hunter.updateMinionAttributes(false)));
    public static final RegistryObject<ISkill<IHunterPlayer>> MINION_TECH_CROSSBOWS = SKILLS.register("minion_tech_crossbows", () -> new VampirismSkill.LordHunterSkill(true));

    @ApiStatus.Internal
    public static void register(IEventBus bus) {
        SKILLS.register(bus);
    }

    public static void fixMappings(@NotNull MissingMappingsEvent event) {
        event.getAllMappings(VampirismRegistries.SKILLS_ID).forEach(missingMapping -> {
            switch (missingMapping.getKey().toString()) {
                case "vampirism:garlic_beacon_improved": {
                    missingMapping.remap((Object)((ISkill)GARLIC_DIFFUSER_IMPROVED.get()));
                    break;
                }
                case "vampirism:garlic_beacon": {
                    missingMapping.remap((Object)((ISkill)GARLIC_DIFFUSER.get()));
                    break;
                }
                case "vampirism:holy_water_enhanced": {
                    missingMapping.remap((Object)((ISkill)ENHANCED_BLESSING.get()));
                    break;
                }
                default: {
                    if (!missingMapping.getKey().toString().startsWith("vampirism:blood_potion_")) break;
                    missingMapping.ignore();
                }
            }
        });
    }

    static {
        SKILLS.register(SkillType.LEVEL.createIdForFaction(VReference.HUNTER_FACTION.getID()).m_135815_(), () -> new VampirismSkill.SimpleHunterSkill(false));
        SKILLS.register(SkillType.LORD.createIdForFaction(VReference.HUNTER_FACTION.getID()).m_135815_(), () -> new VampirismSkill.SimpleHunterSkill(false));
    }
}

