/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.lord.actions;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.DefaultAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class LordRangeEffectAction<T extends IFactionPlayer<T>>
extends DefaultAction<T> {
    private final Supplier<MobEffect> effect;

    public LordRangeEffectAction(Supplier<MobEffect> effect) {
        this.effect = effect;
    }

    @Override
    protected boolean activate(@NotNull T player, IAction.ActivationContext context) {
        int lordLevel = FactionPlayerHandler.getOpt(player.getRepresentingPlayer()).map(FactionPlayerHandler::getLordLevel).orElse(0);
        List entitiesOfClass = player.getRepresentingPlayer().f_19853_.m_6443_(LivingEntity.class, new AABB(player.getRepresentingPlayer().m_20183_()).m_82377_(10.0, 10.0, 10.0), e -> player.getFaction() == VampirismAPI.factionRegistry().getFaction((Entity)e));
        for (LivingEntity entity : entitiesOfClass) {
            if (entity instanceof Player && FactionPlayerHandler.getOpt((Player)entity).map(FactionPlayerHandler::getLordLevel).filter(l -> l >= lordLevel).isPresent()) continue;
            entity.m_7292_(new MobEffectInstance(this.effect.get(), this.getEffectDuration(player), this.getEffectAmplifier(player)));
        }
        return !entitiesOfClass.isEmpty();
    }

    protected abstract int getEffectDuration(T var1);

    @Override
    public int getCooldown(T player) {
        return this.getEffectDuration(player);
    }

    protected int getEffectAmplifier(@NotNull T player) {
        return ((IVampirismPlayer)player.getRepresentingPlayer()).getVampAtts().lordLevel - 1;
    }

    @Override
    @NotNull
    public Optional<IPlayableFaction<?>> getFaction() {
        return Optional.empty();
    }
}

