/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.entity.player.skills.VampirismSkill;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ActionSkill<T extends IFactionPlayer<T>>
extends VampirismSkill<T> {
    private final Supplier<? extends IAction<T>> action;
    private final ISkillType type;

    public ActionSkill(Supplier<? extends IAction<T>> action) {
        this(action, false);
    }

    public ActionSkill(Supplier<? extends IAction<T>> action, boolean customDescription) {
        this(action, SkillType.LEVEL, false);
    }

    public ActionSkill(Supplier<? extends IAction<T>> action, ISkillType type, boolean customDescription) {
        this.action = action;
        this.type = type;
        if (customDescription) {
            this.setHasDefaultDescription();
        } else {
            this.setDescription(() -> Component.m_237115_((String)"text.vampirism.skill.unlocks_action"));
        }
    }

    public ResourceLocation getActionID() {
        return RegUtil.id(this.action.get());
    }

    @Override
    @NotNull
    public Optional<IPlayableFaction<?>> getFaction() {
        return this.action.get().getFaction();
    }

    @Override
    public Component getName() {
        return this.action.get().getName();
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return this.action.get().getTranslationKey();
    }

    @Override
    protected void getActions(@NotNull Collection<IAction<T>> list) {
        list.add(this.action.get());
    }

    @Override
    public ISkillType getType() {
        return this.type;
    }
}

