/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class VampirismSkill<T extends IFactionPlayer<T>>
extends DefaultSkill<T> {
    private Supplier<Component> description = () -> null;
    private Consumer<T> activate = player -> {};
    private Consumer<T> deactivate = player -> {};

    @Override
    public Component getDescription() {
        return this.description.get();
    }

    @NotNull
    public VampirismSkill<T> setDescription(Supplier<Component> descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    @NotNull
    public VampirismSkill<T> setHasDefaultDescription() {
        this.description = () -> Component.m_237115_((String)(this.getTranslationKey() + ".desc"));
        return this;
    }

    @NotNull
    public VampirismSkill<T> setToggleActions(Consumer<T> activateIn, Consumer<T> deactivateIn) {
        this.activate = activateIn;
        this.deactivate = deactivateIn;
        return this;
    }

    @Override
    protected void onDisabled(T player) {
        this.deactivate.accept(player);
        super.onDisabled(player);
    }

    @Override
    protected void onEnabled(T player) {
        this.activate.accept(player);
        super.onEnabled(player);
    }

    public static class LordVampireSkill
    extends SimpleVampireSkill {
        public LordVampireSkill(boolean desc) {
            super(desc);
        }

        @Override
        @NotNull
        public ISkillType getType() {
            return SkillType.LORD;
        }
    }

    public static class SimpleVampireSkill
    extends VampirismSkill<IVampirePlayer> {
        public SimpleVampireSkill(boolean desc) {
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return Optional.of(VReference.VAMPIRE_FACTION);
        }

        @Override
        @NotNull
        public ISkillType getType() {
            return SkillType.LEVEL;
        }
    }

    public static class LordHunterSkill
    extends SimpleHunterSkill {
        public LordHunterSkill(boolean desc) {
            super(desc);
        }

        @Override
        @NotNull
        public ISkillType getType() {
            return SkillType.LORD;
        }
    }

    public static class SimpleHunterSkill
    extends VampirismSkill<IHunterPlayer> {
        public SimpleHunterSkill(boolean desc) {
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        @NotNull
        public Optional<IPlayableFaction<?>> getFaction() {
            return Optional.of(VReference.HUNTER_FACTION);
        }

        @Override
        @NotNull
        public ISkillType getType() {
            return SkillType.LEVEL;
        }
    }
}

