/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.api.util.NonnullSupplier;
import de.teamlapen.vampirism.api.util.NullableSupplier;
import de.teamlapen.vampirism.entity.player.tasks.req.BooleanRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.EntityRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.EntityTypeRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.StatRequirement;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.entity.player.tasks.unlock.ParentUnlocker;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskBuilder {
    @NotNull
    private final Map<TaskRequirement.Type, List<TaskRequirement.Requirement<?>>> requirement = Maps.newHashMapWithExpectedSize((int)TaskRequirement.Type.values().length);
    @NotNull
    private final List<TaskUnlocker> unlocker = Lists.newArrayList();
    @Nullable
    private TaskReward reward;
    @NotNull
    private NullableSupplier<IPlayableFaction<?>> faction = () -> null;
    @NotNull
    private Task.Variant variant = Task.Variant.REPEATABLE;
    private boolean useDescription = false;

    @NotNull
    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    private TaskBuilder() {
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull EntityType<?> entityType, int amount) {
        return this.addRequirement(new EntityRequirement(new ResourceLocation(this.modId(), name), entityType, amount));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull TagKey<EntityType<?>> entityType, int amount) {
        return this.addRequirement(new EntityTypeRequirement(new ResourceLocation(this.modId(), name), entityType, amount));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull ResourceLocation stat, int amount) {
        return this.addRequirement(new StatRequirement(new ResourceLocation(this.modId(), name), stat, amount));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, NonnullSupplier<ItemStack> itemStack) {
        return this.addRequirement(new ItemRequirement(new ResourceLocation(this.modId(), name), itemStack));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull String name, @NotNull BooleanRequirement.BooleanSupplier function) {
        return this.addRequirement(new BooleanRequirement(new ResourceLocation(this.modId(), name), function));
    }

    @NotNull
    public TaskBuilder addRequirement(@NotNull TaskRequirement.Requirement<?> requirement) {
        this.requirement.computeIfAbsent(requirement.getType(), type -> Lists.newArrayListWithExpectedSize((int)3)).add(requirement);
        return this;
    }

    @NotNull
    public Task build() {
        if (this.requirement.isEmpty()) {
            throw new IllegalStateException("Task needs requirements");
        }
        if (this.reward == null) {
            throw new IllegalStateException("Task needs a reward");
        }
        return new Task(this.variant, this.faction, new TaskRequirement(this.requirement), this.reward, this.unlocker.toArray(new TaskUnlocker[0]), this.useDescription);
    }

    @NotNull
    public TaskBuilder enableDescription() {
        this.useDescription = true;
        return this;
    }

    @NotNull
    public TaskBuilder requireParent(@NotNull Task parentTask) {
        return this.requireParent(() -> parentTask);
    }

    @NotNull
    public TaskBuilder requireParent(@Nullable Supplier<Task> parentTask) {
        this.unlocker.add(new ParentUnlocker(parentTask));
        return this;
    }

    @NotNull
    public TaskBuilder setReward(NonnullSupplier<ItemStack> reward) {
        this.reward = new ItemReward(reward);
        return this;
    }

    @NotNull
    public TaskBuilder setReward(TaskReward reward) {
        this.reward = reward;
        return this;
    }

    @NotNull
    public TaskBuilder setUnique() {
        this.variant = Task.Variant.UNIQUE;
        return this;
    }

    @NotNull
    public TaskBuilder unlockedBy(TaskUnlocker unlocker) {
        this.unlocker.add(unlocker);
        return this;
    }

    @NotNull
    public TaskBuilder withFaction(@NotNull NullableSupplier<IPlayableFaction<?>> faction) {
        this.faction = faction;
        return this;
    }

    @NotNull
    protected String modId() {
        return "vampirism";
    }
}

