/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.reward;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LordLevelReward
implements TaskReward,
ITaskRewardInstance {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "lord_level_reward");
    public final int targetLevel;

    @NotNull
    public static LordLevelReward decode(@NotNull FriendlyByteBuf buffer) {
        return new LordLevelReward(buffer.m_130242_());
    }

    @NotNull
    public static LordLevelReward readNbt(@NotNull CompoundTag nbt) {
        return new LordLevelReward(nbt.m_128451_("targetLevel"));
    }

    public LordLevelReward(int targetLevel) {
        this.targetLevel = targetLevel;
    }

    @Override
    public void applyReward(@NotNull IFactionPlayer<?> p) {
        FactionPlayerHandler.getOpt(p.getRepresentingPlayer()).ifPresent(fph -> {
            if (fph.getLordLevel() == this.targetLevel - 1) {
                fph.setLordLevel(this.targetLevel);
            }
        });
    }

    @Override
    @NotNull
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return this;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        buffer.m_130130_(this.targetLevel);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @NotNull
    public CompoundTag writeNBT(@NotNull CompoundTag nbt) {
        nbt.m_128405_("targetLevel", this.targetLevel);
        return nbt;
    }
}

