/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire;

import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.DamageHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BloodStats
implements IBloodStats {
    private static final Logger LOGGER = LogManager.getLogger(BloodStats.class);
    private final Player player;
    private int maxBlood = 20;
    private int bloodLevel = 20;
    private float bloodSaturationLevel = 5.0f;
    private float bloodExhaustionLevel;
    private int bloodTimer;
    private int prevBloodLevel = 20;
    private boolean changed = false;

    BloodStats(Player player) {
        this.player = player;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodLevel;
    }

    void setBloodLevel(int amt) {
        this.bloodLevel = amt < 0 ? 0 : Math.min(amt, this.maxBlood);
        this.changed = true;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    void setMaxBlood(int maxBlood) {
        this.maxBlood = Math.max(1, maxBlood);
        if (this.bloodLevel > maxBlood) {
            this.bloodLevel = maxBlood;
        }
        this.changed = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getPrevBloodLevel() {
        return this.prevBloodLevel;
    }

    @Override
    public boolean needsBlood() {
        return this.bloodLevel < this.maxBlood;
    }

    public boolean onUpdate() {
        boolean regen;
        float bloodExhaustionGate;
        FoodData foodStats = this.player.m_36324_();
        foodStats.m_38705_(10);
        Difficulty enumDifficulty = this.player.m_20193_().m_46791_();
        float exhaustion = foodStats.f_38698_;
        foodStats.f_38698_ = 0.0f;
        this.addExhaustion(exhaustion);
        this.prevBloodLevel = this.bloodLevel;
        float f = bloodExhaustionGate = this.player.m_20193_().m_204166_(this.player.m_20183_()).m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME) ? 6.0f : 4.0f;
        if (this.bloodExhaustionLevel > bloodExhaustionGate) {
            this.bloodExhaustionLevel -= bloodExhaustionGate;
            if (this.bloodSaturationLevel > 0.0f) {
                this.bloodSaturationLevel = Math.max(this.bloodSaturationLevel - 1.0f, 0.0f);
            } else if (enumDifficulty != Difficulty.PEACEFUL || ((Boolean)VampirismConfig.BALANCE.vpBloodUsagePeaceful.get()).booleanValue()) {
                this.bloodLevel = Math.max(this.bloodLevel - 1, 0);
            }
        }
        if ((regen = this.player.m_20193_().m_46469_().m_46207_(GameRules.f_46139_)) && this.bloodSaturationLevel > 0.0f && this.player.m_36325_() && this.bloodLevel >= this.maxBlood) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 10) {
                float f2 = Math.min(this.bloodSaturationLevel, 4.0f);
                this.player.m_5634_(f2 / 4.0f);
                this.addExhaustion(f2, true);
                this.bloodTimer = 0;
            }
        } else if (regen && this.bloodLevel >= 18 && this.player.m_36325_()) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                this.player.m_5634_(1.0f);
                this.addExhaustion(2.8f, true);
                this.bloodTimer = 0;
            }
        } else if (this.bloodLevel <= 0) {
            ++this.bloodTimer;
            if (this.bloodTimer >= 80) {
                if (this.player.m_21223_() > 10.0f || enumDifficulty == Difficulty.HARD || this.player.m_21223_() > 1.0f && enumDifficulty == Difficulty.NORMAL) {
                    DamageHandler.hurtVanilla((Entity)this.player, DamageSources::m_269064_, 1.5f);
                }
                this.bloodTimer = 0;
            }
        } else {
            this.bloodTimer = 0;
        }
        if (this.changed || this.prevBloodLevel != this.bloodLevel) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public void readNBT(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("bloodLevel")) {
            this.bloodLevel = nbt.m_128451_("bloodLevel");
            if (nbt.m_128441_("bloodTimer")) {
                this.bloodTimer = nbt.m_128451_("bloodTimer");
                this.bloodSaturationLevel = nbt.m_128457_("bloodSaturation");
                this.bloodExhaustionLevel = nbt.m_128457_("bloodExhaustion");
            }
            if (nbt.m_128441_("maxBlood")) {
                this.maxBlood = nbt.m_128451_("maxBlood");
            }
        }
    }

    int addBlood(int amount, float saturationModifier) {
        int add = Math.min(amount, this.maxBlood - this.bloodLevel);
        this.bloodLevel += add;
        this.bloodSaturationLevel = Math.min(this.bloodSaturationLevel + (float)add * saturationModifier * 2.0f, (float)this.bloodLevel);
        this.changed = true;
        return amount - add;
    }

    void addExhaustion(float amount) {
        this.addExhaustion(amount, false);
    }

    void addExhaustion(float amount, boolean ignoreModifier) {
        if (!ignoreModifier) {
            AttributeInstance attribute = this.player.m_21051_((Attribute)ModAttributes.BLOOD_EXHAUSTION.get());
            amount = (float)((double)amount * attribute.m_22135_());
        }
        this.bloodExhaustionLevel = Math.min(this.bloodExhaustionLevel + amount, 40.0f);
    }

    void loadUpdate(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("maxBlood")) {
            this.setMaxBlood(nbt.m_128451_("maxBlood"));
        }
        if (nbt.m_128441_("bloodLevel")) {
            this.setBloodLevel(nbt.m_128451_("bloodLevel"));
        }
    }

    boolean removeBlood(int a, boolean allowPartial) {
        if (this.bloodLevel >= a) {
            this.bloodLevel -= a;
            this.changed = true;
            return true;
        }
        if (allowPartial) {
            this.bloodLevel = 0;
            this.changed = true;
        }
        return false;
    }

    void writeNBT(@NotNull CompoundTag nbt) {
        this.writeNBTBlood(nbt);
        nbt.m_128405_("bloodTimer", this.bloodTimer);
        nbt.m_128350_("bloodSaturation", this.bloodSaturationLevel);
        nbt.m_128350_("bloodExhaustion", this.bloodExhaustionLevel);
        nbt.m_128405_("maxBlood", this.maxBlood);
    }

    void writeNBTBlood(@NotNull CompoundTag nbt) {
        nbt.m_128405_("bloodLevel", this.bloodLevel);
    }

    @NotNull
    CompoundTag writeUpdate(@NotNull CompoundTag nbt) {
        nbt.m_128405_("bloodLevel", this.bloodLevel);
        nbt.m_128405_("maxBlood", this.maxBlood);
        return nbt;
    }
}

