/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import com.mojang.authlib.GameProfile;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.VampireBookLootProvider;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.vampire.IAdvancedVampire;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.action.ActionHandlerEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.entity.ai.goals.AttackVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.DefendVillageGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeGarlicVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.IPlayerOverlay;
import de.teamlapen.vampirism.util.PlayerSkinHelper;
import de.teamlapen.vampirism.util.SupporterManager;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedVampireEntity
extends VampireBaseEntity
implements IAdvancedVampire,
IPlayerOverlay,
IEntityActionUser,
VampireBookLootProvider {
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> NAME = SynchedEntityData.m_135353_(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(AdvancedVampireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final int MAX_LEVEL = 1;
    @NotNull
    private final ActionHandlerEntity<?> entityActionHandler;
    private final EntityClassType entityclass;
    @NotNull
    private final EntityActionTier entitytier;
    private int followingEntities = 0;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Pair<ResourceLocation, Boolean> skinDetails;
    @Nullable
    private String lootBookId;
    @Nullable
    private ICaptureAttributes villageAttributes;
    private boolean attack;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.m_22268_(Attributes.f_22276_, 60.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder3 = builder2.m_22268_(Attributes.f_22281_, 7.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder3.m_22268_(Attributes.f_22279_, 0.285).m_22268_(Attributes.f_22277_, 13.0);
    }

    public AdvancedVampireEntity(EntityType<? extends AdvancedVampireEntity> type, Level world) {
        super(type, world, true);
        this.canSuckBloodFromPlayer = true;
        this.setSpawnRestriction(VampireBaseEntity.SpawnRestriction.SPECIAL);
        this.setDontDropEquipment();
        this.entitytier = EntityActionTier.High;
        this.entityclass = EntityClassType.getRandomClass(this.m_217043_());
        IEntityActionUser.applyAttributes(this);
        this.entityActionHandler = new ActionHandlerEntity<AdvancedVampireEntity>(this);
        this.enableImobConversion();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("level", this.getEntityLevel());
        nbt.m_128405_("type", this.getEyeType());
        nbt.m_128359_("texture", (String)this.m_20088_().m_135370_(TEXTURE));
        nbt.m_128359_("name", (String)this.m_20088_().m_135370_(NAME));
        nbt.m_128405_("entityclasstype", EntityClassType.getID(this.entityclass));
        if (this.entityActionHandler != null) {
            this.entityActionHandler.write(nbt);
        }
        nbt.m_128379_("attack", this.attack);
        if (this.lootBookId != null) {
            nbt.m_128359_("lootBookId", this.lootBookId);
        }
    }

    @Override
    public void attackVillage(ICaptureAttributes totem) {
        this.villageAttributes = totem;
        this.attack = true;
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    @Override
    public void defendVillage(ICaptureAttributes totem) {
        this.villageAttributes = totem;
        this.attack = false;
    }

    @Override
    public ActionHandlerEntity<?> getActionHandler() {
        return this.entityActionHandler;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.entityActionHandler != null) {
            this.entityActionHandler.handle();
        }
    }

    @Override
    @NotNull
    public Optional<String> getBookLootId() {
        return Optional.ofNullable(this.lootBookId);
    }

    @Override
    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityclass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entitytier;
    }

    @Override
    public int getEyeType() {
        return (Integer)this.m_20088_().m_135370_(TYPE);
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 1) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 0));
            }
        }
    }

    @Override
    public int getMaxFollowerCount() {
        return BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER;
    }

    @Override
    public int getMaxEntityLevel() {
        return 1;
    }

    @NotNull
    public Component m_7755_() {
        String senderName = (String)this.m_20088_().m_135370_(NAME);
        return "none".equals(senderName) ? super.m_7755_() : Component.m_237113_((String)senderName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Optional<Pair<ResourceLocation, Boolean>> getOverlayPlayerProperties() {
        if (this.skinDetails == null) {
            String name = this.getTextureName();
            if (name == null) {
                return Optional.empty();
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PlayerSkinHelper.obtainPlayerSkinPropertiesAsync(new GameProfile(null, name), p -> {
                this.skinDetails = p;
            }));
            this.skinDetails = PENDING_PROP;
        }
        return Optional.of(this.skinDetails);
    }

    @Override
    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    @Override
    @Nullable
    public String getTextureName() {
        String texture = (String)this.m_20088_().m_135370_(TEXTURE);
        return "none".equals(texture) ? null : texture;
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    @Override
    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        boolean flag = super.m_6469_(damageSource, amount);
        if (flag && damageSource.m_7639_() instanceof Player && this.f_19796_.m_188503_(4) == 0) {
            this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SUNSCREEN.get(), 150, 2));
        }
        return flag;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tagCompund) {
        super.m_7378_(tagCompund);
        if (tagCompund.m_128441_("level")) {
            this.setEntityLevel(tagCompund.m_128451_("level"));
        }
        if (tagCompund.m_128441_("type")) {
            this.m_20088_().m_135381_(TYPE, (Object)tagCompund.m_128451_("type"));
            this.m_20088_().m_135381_(NAME, (Object)tagCompund.m_128461_("name"));
            this.m_20088_().m_135381_(TEXTURE, (Object)tagCompund.m_128461_("texture"));
        }
        if (this.entityActionHandler != null) {
            this.entityActionHandler.read(tagCompund);
        }
        if (tagCompund.m_128441_("attack")) {
            this.attack = tagCompund.m_128471_("attack");
        }
        if (tagCompund.m_128441_("lootBookId")) {
            this.lootBookId = tagCompund.m_128461_("lootBookId");
        }
    }

    @Override
    public void stopVillageAttackDefense() {
        this.m_6593_(null);
        this.villageAttributes = null;
    }

    public boolean m_6052_() {
        return true;
    }

    @Override
    public int suggestEntityLevel(@NotNull Difficulty d) {
        if (this.f_19796_.m_188499_()) {
            return (int)((float)(d.avgPercLevel * 1) / 100.0f);
        }
        return this.f_19796_.m_188503_(2);
    }

    @Override
    protected float calculateFireDamage(float amount) {
        double d = amount;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return (float)(d * 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
        this.m_20088_().m_135372_(TYPE, (Object)0);
        this.m_20088_().m_135372_(NAME, (Object)"none");
        this.m_20088_().m_135372_(TEXTURE, (Object)"none");
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SupporterManager.Supporter supporter = SupporterManager.getInstance().getRandomVampire(this.f_19796_);
        this.lootBookId = supporter.bookID();
        this.m_20088_().m_135381_(TYPE, (Object)supporter.typeId());
        this.m_20088_().m_135381_(NAME, (Object)(supporter.senderName() == null ? "none" : supporter.senderName()));
        this.m_20088_().m_135381_(TEXTURE, (Object)(supporter.textureName() == null ? "none" : supporter.textureName()));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.ADVANCED_VAMPIRE_IMOB.get() : (EntityType)ModEntities.ADVANCED_VAMPIRE.get();
    }

    public int m_213860_() {
        return 10 * (1 + this.getEntityLevel());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BreakDoorGoal((Mob)this, difficulty -> difficulty == net.minecraft.world.Difficulty.HARD));
        this.f_21345_.m_25352_(2, new RestrictSunVampireGoal<AdvancedVampireEntity>(this));
        this.f_21345_.m_25352_(3, new FleeSunVampireGoal<AdvancedVampireEntity>(this, 0.9, false));
        this.f_21345_.m_25352_(3, (Goal)new FleeGarlicVampireGoal(this, 0.9, false));
        this.f_21345_.m_25352_(4, (Goal)new AttackMeleeNoSunGoal(this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9, 25));
        this.f_21345_.m_25352_(9, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 13.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AttackVillageGoal<AdvancedVampireEntity>(this));
        this.f_21346_.m_25352_(2, new DefendVillageGoal<AdvancedVampireEntity>(this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey<Structure>)StructureTags.f_215889_)));
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(60.0 + BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_HEALTH_PL * (double)l);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(7.0 + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)l);
    }

    public static class IMob
    extends AdvancedVampireEntity
    implements Enemy {
        public IMob(EntityType<? extends AdvancedVampireEntity> type, Level world) {
            super(type, world);
        }
    }
}

