/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public abstract class VampireBaseEntity
extends VampirismEntity
implements IVampireMob,
Npc {
    private final boolean countAsMonsterForSpawn;
    @NotNull
    protected EnumStrength garlicResist = EnumStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    protected boolean vulnerableToFire = true;
    private SpawnRestriction spawnRestriction = SpawnRestriction.NORMAL;
    private boolean sundamageCache;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean dropSoul = false;

    public static boolean spawnPredicateVampire(@NotNull EntityType<? extends VampirismEntity> entityType, @NotNull ServerLevelAccessor world, MobSpawnType spawnReason, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && (Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)blockPos, (RandomSource)random) || VampireBaseEntity.spawnPredicateVampireFog((LevelAccessor)world, blockPos)) && Mob.m_217057_(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampirismEntity.getAttributeBuilder();
        Attribute attribute = (Attribute)ModAttributes.SUNDAMAGE.get();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.m_22268_(attribute, 7.0);
    }

    public VampireBaseEntity(EntityType<? extends VampireBaseEntity> type, Level world, boolean countAsMonsterForSpawn) {
        super(type, world);
        this.countAsMonsterForSpawn = countAsMonsterForSpawn;
    }

    @Override
    public void m_8107_() {
        if (this.f_19797_ % 40 == 3) {
            this.isGettingGarlicDamage((LevelAccessor)this.f_19853_, true);
        }
        if (this.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.f_19853_, true);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isGettingSundamage((LevelAccessor)this.f_19853_) && this.m_6084_()) {
                double dmg;
                if (((Boolean)VampirismConfig.BALANCE.vpSundamageInstantDeath.get()).booleanValue()) {
                    DamageHandler.hurtModded((Entity)this, ModDamageSources::sunDamage, 1000.0f);
                    this.turnToAsh();
                } else if (this.f_19797_ % 40 == 11 && (dmg = this.m_21051_((Attribute)ModAttributes.SUNDAMAGE.get()).m_22135_()) > 0.0) {
                    DamageHandler.hurtModded((Entity)this, ModDamageSources::sunDamage, (float)dmg);
                }
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.f_19853_) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.f_19853_), this.f_19797_);
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_20069_()) {
            this.m_20301_(300);
            if (this.f_19797_ % 16 == 4) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0));
            }
        }
        super.m_8107_();
    }

    private void turnToAsh() {
        if (!this.m_6084_()) {
            this.f_20919_ = 19;
            ModParticles.spawnParticlesServer(this.f_19853_, (ParticleOptions)ParticleTypes.f_123790_, this.m_20185_() + 0.5, this.m_20186_() + (double)this.m_20206_(), this.m_20189_() + 0.5, 20, 0.2, (double)this.m_20206_() * 0.2, 0.2, 0.1);
            ModParticles.spawnParticlesServer(this.f_19853_, (ParticleOptions)ParticleTypes.f_123783_, this.m_20185_() + 0.5, this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_() + 0.5, 20, 0.2, (double)this.m_20206_() * 0.2, 0.2, 0.1);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public boolean m_5545_(@NotNull LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        if (this.spawnRestriction.level >= SpawnRestriction.SIMPLE.level) {
            if (this.isGettingSundamage(worldIn, true) || this.isGettingGarlicDamage(worldIn, true) != EnumStrength.NONE) {
                return false;
            }
            if (this.spawnRestriction.level >= SpawnRestriction.NORMAL.level) {
                if ((double)(-worldIn.m_220419_(this.m_20183_())) < 0.0 && this.f_19796_.m_188503_(5) != 0) {
                    return false;
                }
                if (this.f_19853_.m_46749_(this.m_20183_()) && worldIn instanceof ServerLevel && UtilLib.getStructureStartAt(this.f_19853_, this.m_20183_(), (TagKey<Structure>)StructureTags.f_215889_).isPresent() && this.m_217043_().m_188503_(60) != 0) {
                    return false;
                }
                if (this.spawnRestriction.level >= SpawnRestriction.SPECIAL.level && !this.getCanSpawnHereRestricted(worldIn)) {
                    return false;
                }
            }
        }
        return super.m_5545_(worldIn, spawnReasonIn);
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        if (cause.m_7640_() instanceof CrossbowArrowEntity && Helper.isHunter(cause.m_7639_())) {
            this.dropSoul = true;
        } else if (cause.m_7640_() instanceof Player && Helper.isHunter(cause.m_7640_())) {
            ItemStack weapon = ((Player)cause.m_7640_()).m_21205_();
            if (!weapon.m_41619_() && weapon.m_41720_() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    @Override
    public boolean doesResistGarlic(@NotNull EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        Player player;
        if (this.canSuckBloodFromPlayer && !this.f_19853_.f_46443_ && this.wantsBlood() && entity instanceof Player && !Helper.isHunter(player = (Player)entity) && !UtilLib.canReallySee((LivingEntity)player, (LivingEntity)this, true)) {
            int amt = VampirePlayer.getOpt(player).map(v -> v.onBite(this)).orElse(0);
            this.drinkBlood(amt, 0.7f);
            VampirePlayer.getOpt(player).ifPresent(v -> v.tryInfect(this));
            return true;
        }
        for (ItemStack e : entity.m_6168_()) {
            if (e == null || !(e.m_41720_() instanceof HunterCoatItem)) continue;
            int j = 1;
            if (((HunterCoatItem)e.m_41720_()).getVampirismTier().equals((Object)IItemWithTier.TIER.ENHANCED)) {
                j = 2;
            } else if (((HunterCoatItem)e.m_41720_()).getVampirismTier().equals((Object)IItemWithTier.TIER.ULTIMATE)) {
                j = 3;
            }
            if (this.m_217043_().m_188503_((4 - j) * 2) != 0) continue;
            this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), (int)(20.0 * Math.sqrt(j)), j));
        }
        return super.m_7327_(entity);
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonsterForSpawn) {
            return MobCategory.MONSTER;
        }
        return super.getClassification(forSpawnCount);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, amt * 20));
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @NotNull
    public MobType m_6336_() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (damageSource.m_276093_(DamageTypes.f_268631_)) {
                return DamageHandler.hurtModded((Entity)this, ModDamageSources::vampireInFire, this.calculateFireDamage(amount));
            }
            if (damageSource.m_276093_(DamageTypes.f_268468_)) {
                return DamageHandler.hurtModded((Entity)this, ModDamageSources::vampireOnFire, this.calculateFireDamage(amount));
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.f_19853_.m_46473_());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.m_21023_((MobEffect)ModEffects.SUNSCREEN.get());
    }

    public void setSpawnRestriction(SpawnRestriction r) {
        this.spawnRestriction = r;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void m_6153_() {
        if (this.f_20919_ == 19 && !this.f_19853_.f_46443_ && this.dropSoul && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.f_19853_.m_7967_((Entity)new SoulOrbEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
        super.m_6153_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    private boolean getCanSpawnHereRestricted(@NotNull LevelAccessor iWorld) {
        boolean vampireBiome = iWorld.m_204166_(this.m_20183_()).m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME);
        boolean lowLightLevel = this.isLowLightLevel(iWorld);
        if (lowLightLevel) {
            return true;
        }
        if (!vampireBiome) {
            return false;
        }
        BlockState iblockstate = iWorld.m_8055_(this.m_20183_().m_7495_());
        return iblockstate.m_204336_(ModTags.Blocks.CURSED_EARTH);
    }

    public static enum SpawnRestriction {
        NONE(0),
        SIMPLE(1),
        NORMAL(2),
        SPECIAL(3);

        final int level;

        private SpawnRestriction(int level) {
            this.level = level;
        }
    }
}

