/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.IDefaultTaskMasterEntity;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.TaskBoardMenu;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireTaskMasterEntity
extends VampireBaseEntity
implements IDefaultTaskMasterEntity {
    private static final EntityDataAccessor<String> BIOME_TYPE = SynchedEntityData.m_135353_(VampireTaskMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Nullable
    private Player interactor;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, (double)BalanceMobProps.mobProps.SANGUINARE_AVG_DURATION);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder.m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, BalanceMobProps.mobProps.VAMPIRE_SPEED);
    }

    public VampireTaskMasterEntity(EntityType<? extends VampireBaseEntity> type, Level world) {
        super(type, world, false);
        this.peaceful = true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!(this.interactor == null || this.interactor.m_6084_() && this.interactor.f_36096_ instanceof TaskBoardMenu)) {
            this.interactor = null;
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiomeType(VillagerType.m_204073_((Holder)worldIn.m_204166_(this.m_20183_())));
        return data;
    }

    @Override
    @NotNull
    public VillagerType getBiomeType() {
        String key = (String)this.f_19804_.m_135370_(BIOME_TYPE);
        ResourceLocation id = new ResourceLocation(key);
        return (VillagerType)BuiltInRegistries.f_256934_.m_7745_(id);
    }

    protected void setBiomeType(@NotNull VillagerType type) {
        this.f_19804_.m_135381_(BIOME_TYPE, (Object)BuiltInRegistries.f_256934_.m_7981_((Object)type).toString());
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.interactor);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6052_() {
        return Helper.isVampire((Player)Minecraft.m_91087_().f_91074_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIOME_TYPE, (Object)BuiltInRegistries.f_256934_.m_122315_().toString());
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player playerEntity, @NotNull InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            return Helper.isVampire(playerEntity) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (Helper.isVampire(playerEntity) && this.interactor == null) {
            if (this.processInteraction(playerEntity, (Entity)this)) {
                this.m_21573_().m_26573_();
                this.interactor = playerEntity;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        this.f_21345_.m_25352_(2, new RestrictSunVampireGoal<VampireTaskMasterEntity>(this));
        this.f_21345_.m_25352_(2, new ForceLookEntityGoal<VampireTaskMasterEntity>(this));
        this.f_21345_.m_25352_(3, new FleeSunVampireGoal<VampireTaskMasterEntity>(this, 0.9, false));
        this.f_21345_.m_25352_(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.6, true, 600, () -> false));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }
}

