/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.items.HunterIntelItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTrainerMenu
extends InventoryContainerMenu
implements ContainerListener {
    private static final InventoryContainerMenu.SelectorInfo[] SELECTOR_INFOS = new InventoryContainerMenu.SelectorInfo[]{new InventoryContainerMenu.SelectorInfo(Items.f_42416_, 27, 26), new InventoryContainerMenu.SelectorInfo(Items.f_42417_, 57, 26), new InventoryContainerMenu.SelectorInfo(ModTags.Items.HUNTER_INTEL, 86, 26)};
    @NotNull
    private final Player player;
    @Nullable
    private final HunterTrainerEntity entity;
    private boolean changed = false;
    @NotNull
    private ItemStack missing = ItemStack.f_41583_;

    @Deprecated
    public HunterTrainerMenu(int id, @NotNull Inventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterTrainerMenu(int id, @NotNull Inventory playerInventory, @Nullable HunterTrainerEntity trainer) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModContainer.HUNTER_TRAINER.get()), id, playerInventory, trainer == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)trainer.f_19853_, (BlockPos)trainer.m_20183_()), (Container)new SimpleContainer(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((SimpleContainer)this.inventory).m_19164_((ContainerListener)this);
        this.player = playerInventory.f_35978_;
        this.addPlayerSlots(playerInventory);
        this.entity = trainer;
    }

    public void m_5757_(@NotNull Container iInventory) {
        this.changed = true;
    }

    public boolean canLevelup() {
        int targetLevel = FactionPlayerHandler.getOpt(this.player).map(h -> h.getCurrentLevel(VReference.HUNTER_FACTION)).orElse(0) + 1;
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        if (levelingConf.isLevelValidForTrainer(targetLevel) != 0) {
            return false;
        }
        int[] req = levelingConf.getItemRequirementsForTrainer(targetLevel);
        int level = levelingConf.getHunterIntelMetaForLevel(targetLevel);
        this.missing = InventoryHelper.checkItems(this.inventory, new Item[]{Items.f_42416_, Items.f_42417_, HunterIntelItem.getIntelForLevel(level)}, new int[]{req[0], req[1], 1}, (supplied, required) -> supplied.equals(required) || supplied instanceof HunterIntelItem && required instanceof HunterIntelItem && ((HunterIntelItem)((Object)supplied)).getLevel() >= ((HunterIntelItem)((Object)required)).getLevel());
        return this.missing.m_41619_();
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean hasChanged() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    public void onLevelupClicked() {
        if (this.canLevelup()) {
            int old = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION);
            FactionPlayerHandler.get(this.player).setFactionLevel(VReference.HUNTER_FACTION, old + 1);
            int[] req = HunterLevelingConf.instance().getItemRequirementsForTrainer(old + 1);
            InventoryHelper.removeItems(this.inventory, new int[]{req[0], req[1], 1});
            this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SATURATION.get(), 400, 2));
            this.changed = true;
        }
    }

    @Override
    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.m_20193_().f_46443_) {
            this.m_150411_(playerIn, this.inventory);
        }
    }

    @Override
    public boolean m_6875_(@NotNull Player player) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82554_(new Vec3(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_())) < 5.0;
    }
}

