/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import com.google.common.collect.Sets;
import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.inventory.TaskMenu;
import de.teamlapen.vampirism.network.ServerboundTaskActionPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskBoardMenu
extends AbstractContainerMenu
implements TaskMenu {
    @NotNull
    private final Set<UUID> completableTasks = Sets.newHashSet();
    @NotNull
    private final List<ITaskInstance> taskInstances = new ArrayList<ITaskInstance>();
    @NotNull
    private final TextColor factionColor;
    @NotNull
    private final IFactionPlayer<?> factionPlayer;
    @Nullable
    private Map<UUID, Map<ResourceLocation, Integer>> completedRequirements;
    private UUID taskBoardId;
    @Nullable
    private Runnable listener;

    public TaskBoardMenu(int id, @NotNull Inventory playerInventory) {
        super((MenuType)ModContainer.TASK_MASTER.get(), id);
        this.factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer(playerInventory.f_35978_).orElseThrow(() -> new IllegalStateException("Can't open container without faction"));
        this.factionColor = this.factionPlayer.getFaction().getChatColor();
    }

    @Override
    public boolean areRequirementsCompleted(@NotNull ITaskInstance task, @NotNull TaskRequirement.Type type) {
        if (task.isCompleted()) {
            return true;
        }
        if (this.completableTasks.contains(task.getId())) {
            return true;
        }
        if (this.completedRequirements != null && this.completedRequirements.containsKey(task.getId())) {
            for (TaskRequirement.Requirement<?> requirement : task.getTask().getRequirement().requirements().get((Object)type)) {
                if (this.completedRequirements.get(task.getId()).containsKey(requirement.getId()) && this.completedRequirements.get(task.getId()).get(requirement.getId()) >= requirement.getAmount(this.factionPlayer)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TaskMenu.TaskAction buttonAction(@NotNull ITaskInstance taskInfo) {
        if (this.canCompleteTask(taskInfo)) {
            return TaskMenu.TaskAction.COMPLETE;
        }
        if (this.isTaskNotAccepted(taskInfo)) {
            return TaskMenu.TaskAction.ACCEPT;
        }
        if (!taskInfo.isUnique() && this.factionPlayer.getRepresentingPlayer().f_19853_.m_46467_() > taskInfo.getTaskTimeStamp()) {
            return TaskMenu.TaskAction.REMOVE;
        }
        return TaskMenu.TaskAction.ABORT;
    }

    @Override
    public boolean canCompleteTask(@NotNull ITaskInstance taskInfo) {
        return this.completableTasks.contains(taskInfo.getId()) && (taskInfo.isUnique() || this.factionPlayer.getRepresentingPlayer().f_19853_.m_46467_() < taskInfo.getTaskTimeStamp());
    }

    @Override
    public void pressButton(@NotNull ITaskInstance taskInfo) {
        TaskMenu.TaskAction action = this.buttonAction(taskInfo);
        switch (action) {
            case COMPLETE: {
                taskInfo.complete();
                this.completableTasks.remove(taskInfo.getId());
                this.taskInstances.remove(taskInfo);
                VampLib.proxy.createMasterSoundReference((SoundEvent)ModSounds.TASK_COMPLETE.get(), 1.0f, 1.0f).startPlaying();
                break;
            }
            case ACCEPT: {
                taskInfo.startTask(Minecraft.m_91087_().f_91073_.m_46467_() + taskInfo.getTaskDuration());
                break;
            }
            default: {
                taskInfo.aboardTask();
            }
        }
        VampirismMod.dispatcher.sendToServer(new ServerboundTaskActionPacket(taskInfo.getId(), taskInfo.getTaskBoard(), action));
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @NotNull
    public IPlayableFaction<?> getFaction() {
        return this.factionPlayer.getFaction();
    }

    @Override
    @NotNull
    public TextColor getFactionColor() {
        return this.factionColor;
    }

    @Override
    public int getRequirementStatus(@NotNull ITaskInstance taskInfo, @NotNull TaskRequirement.Requirement<?> requirement) {
        assert (this.completedRequirements != null);
        if (this.completedRequirements.containsKey(taskInfo.getId())) {
            return this.completedRequirements.get(taskInfo.getId()).get(requirement.getId());
        }
        return requirement.getAmount(this.factionPlayer);
    }

    public ITaskInstance getTask(int i) {
        return this.taskInstances.get(i);
    }

    public UUID getTaskBoardId() {
        return this.taskBoardId;
    }

    @NotNull
    public List<ITaskInstance> getVisibleTasks() {
        return this.taskInstances;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void init(@NotNull Set<ITaskInstance> available, @NotNull Set<UUID> completableTasks, Map<UUID, Map<ResourceLocation, Integer>> completedRequirements, UUID taskBoardId) {
        this.taskInstances.clear();
        this.taskInstances.addAll(available);
        this.completableTasks.addAll(completableTasks);
        this.completedRequirements = completedRequirements;
        this.taskBoardId = taskBoardId;
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public boolean isCompleted(@NotNull ITaskInstance item) {
        return item.isCompleted();
    }

    @Override
    public boolean isRequirementCompleted(@NotNull ITaskInstance taskInfo, @NotNull TaskRequirement.Requirement<?> requirement) {
        if (taskInfo.isCompleted()) {
            return true;
        }
        if (this.completedRequirements != null && this.completedRequirements.containsKey(taskInfo.getId())) {
            return this.completedRequirements.get(taskInfo.getId()).containsKey(requirement.getId()) && this.completedRequirements.get(taskInfo.getId()).get(requirement.getId()) >= requirement.getAmount(this.factionPlayer);
        }
        return false;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int p_38942_) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return VampirismPlayerAttributes.get((Player)playerIn).faction != null;
    }

    @Override
    public void setReloadListener(@Nullable Runnable listener) {
        this.listener = listener;
    }

    public int size() {
        return this.taskInstances.size();
    }
}

