/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlessableItem
extends Item {
    private final Supplier<Item> blessedItem;
    @Nullable
    private final Supplier<Item> enhancedBlessedItem;
    private static final List<BlessableItem> BLESSABLE_ITEMS = new ArrayList<BlessableItem>();

    @NotNull
    public static List<Recipe> getBlessableRecipes() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (BlessableItem i : BLESSABLE_ITEMS) {
            recipes.add(new Recipe(false, i, i.blessedItem.get()));
            if (i.enhancedBlessedItem == null) continue;
            recipes.add(new Recipe(true, i, i.enhancedBlessedItem.get()));
        }
        return recipes;
    }

    public BlessableItem(@NotNull Item.Properties properties, Supplier<Item> blessedItem, @Nullable Supplier<Item> enhancedBlessedItem) {
        super(properties);
        this.blessedItem = blessedItem;
        this.enhancedBlessedItem = enhancedBlessedItem;
        BLESSABLE_ITEMS.add(this);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 316;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == ModBlocks.ALTAR_CLEANSING.get()) {
            if (!Helper.isHunter(context.m_43723_())) {
                return InteractionResult.PASS;
            }
            context.m_43723_().m_6672_(context.m_43724_());
            context.m_43723_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2));
            context.m_43723_().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 2));
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }

    public void onUsingTick(ItemStack stack, @NotNull LivingEntity entity, int ticksLeft) {
        if (ticksLeft == 300 && entity.f_19853_.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            HunterPlayer.getOpt(player).map(HunterPlayer::getSpecialAttributes).ifPresent(att -> {
                if (att.blessingSoundReference != null) {
                    att.blessingSoundReference.stopPlaying();
                }
                att.blessingSoundReference = VampLib.proxy.createSoundReference((SoundEvent)ModSounds.BLESSING_MUSIC.get(), SoundSource.PLAYERS, entity.m_20183_(), 1.0f, 1.0f);
                att.blessingSoundReference.startPlaying();
            });
        }
        if (ticksLeft % 20 == 1) {
            Vec3 mainPos = UtilLib.getItemPosition(entity, entity.m_7655_() == InteractionHand.MAIN_HAND);
            for (int j = 0; j < 3; ++j) {
                Vec3 pos = mainPos.m_82520_((double)((entity.m_217043_().m_188501_() - 0.5f) * 0.1f), (double)((entity.m_217043_().m_188501_() - 0.3f) * 0.9f), (double)((entity.m_217043_().m_188501_() - 0.5f) * 0.1f));
                UtilLib.spawnParticles(entity.f_19853_, (ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, 10, 0.4f);
            }
            if (ticksLeft > 21) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 2));
            }
        }
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity livingEntity) {
        if (this.enhancedBlessedItem != null && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            boolean enhanced = handler.isInFaction(VReference.HUNTER_FACTION) && handler.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(s -> s.isSkillEnabled((ISkill)HunterSkills.ENHANCED_BLESSING.get())).orElse(false) != false;
            return new ItemStack(enhanced ? (ItemLike)this.enhancedBlessedItem.get() : (ItemLike)this.blessedItem.get(), stack.m_41613_());
        }
        return new ItemStack((ItemLike)this.blessedItem.get(), stack.m_41613_());
    }

    public void m_5551_(ItemStack sttack, Level world, @NotNull LivingEntity entity, int duration) {
        if (entity.f_19853_.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            HunterPlayer.getOpt(player).map(HunterPlayer::getSpecialAttributes).ifPresent(att -> {
                if (att.blessingSoundReference != null) {
                    att.blessingSoundReference.stopPlaying();
                }
            });
        }
    }

    public Item getBlessedItem() {
        return this.blessedItem.get();
    }

    public static class Recipe {
        public final boolean enhanced;
        public final BlessableItem input;
        public final Item output;

        public Recipe(boolean enhanced, BlessableItem input, Item output) {
            this.enhanced = enhanced;
            this.input = input;
            this.output = output;
        }
    }
}

