/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.blocks.AlchemicalFireBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.util.DamageHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrossbowArrowItem
extends ArrowItem
implements IVampirismCrossbowArrow<CrossbowArrowEntity> {
    private final EnumArrowType type;

    public CrossbowArrowItem(EnumArrowType type) {
        super(new Item.Properties());
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> textComponents, TooltipFlag tooltipFlag) {
        switch (this.type) {
            case SPITFIRE: {
                textComponents.add((Component)Component.m_237115_((String)"item.vampirism.crossbow_arrow_spitfire.tooltip").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case VAMPIRE_KILLER: {
                textComponents.add((Component)Component.m_237115_((String)"item.vampirism.crossbow_arrow_vampire_killer.tooltip").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case TELEPORT: {
                textComponents.add((Component)Component.m_237115_((String)"item.vampirism.crossbow_arrow_teleport.tooltip").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @NotNull
    public AbstractArrow m_6394_(@NotNull Level level, @NotNull ItemStack stack, @NotNull LivingEntity entity) {
        CrossbowArrowEntity arrowEntity = new CrossbowArrowEntity(level, entity, stack);
        arrowEntity.setEffectsFromItem(stack);
        arrowEntity.m_36781_(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            arrowEntity.m_20254_(100);
        }
        arrowEntity.f_36705_ = this.type == EnumArrowType.NORMAL ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
        return arrowEntity;
    }

    public EnumArrowType getType() {
        return this.type;
    }

    @Override
    public boolean isCanBeInfinite() {
        return this.type == EnumArrowType.NORMAL || (Boolean)VampirismConfig.BALANCE.allowInfiniteSpecialArrows.get() != false;
    }

    @Override
    public void onHitBlock(ItemStack arrow, @NotNull BlockPos blockPos, IEntityCrossbowArrow arrowEntity, @Nullable Entity shootingEntity) {
        CrossbowArrowEntity entity = (CrossbowArrowEntity)arrowEntity;
        switch (this.type) {
            case SPITFIRE: {
                for (int dx = -1; dx < 2; ++dx) {
                    for (int dy = -2; dy < 2; ++dy) {
                        for (int dz = -1; dz < 2; ++dz) {
                            BlockPos pos = blockPos.m_7918_(dx, dy, dz);
                            BlockState blockState = entity.m_20193_().m_8055_(pos);
                            if (!blockState.m_60767_().m_76336_() || !entity.m_20193_().m_8055_(pos.m_7495_()).m_60783_((BlockGetter)entity.m_20193_(), pos.m_7495_(), Direction.UP) || entity.getRNG().m_188503_(4) == 0) continue;
                            entity.m_20193_().m_46597_(pos, ((AlchemicalFireBlock)((Object)ModBlocks.ALCHEMICAL_FIRE.get())).m_49966_());
                        }
                    }
                }
                break;
            }
            case TELEPORT: {
                if (shootingEntity == null || shootingEntity.f_19853_.f_46443_ || !shootingEntity.m_6084_()) break;
                if (shootingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)shootingEntity;
                    if (!player.f_8906_.f_9742_.m_129536_() || player.f_19853_ != entity.f_19853_ || player.m_5803_()) break;
                    if (player.m_20159_()) {
                        player.m_8127_();
                    }
                    player.m_6021_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                    player.f_19789_ = 0.0f;
                    DamageHandler.hurtVanilla((Entity)player, DamageSources::m_268989_, 1.0f);
                    break;
                }
                shootingEntity.m_6021_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                shootingEntity.f_19789_ = 0.0f;
            }
        }
    }

    @Override
    public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        float max;
        if (this.type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.m_21233_()) < (float)((Integer)VampirismConfig.BALANCE.arrowVampireKillerMaxHealth.get()).intValue()) {
            DamageHandler.hurtVanilla((Entity)entity, damageSources -> damageSources.m_269418_((AbstractArrow)arrowEntity, shootingEntity), max);
        }
    }

    public static enum EnumArrowType implements StringRepresentable
    {
        NORMAL("normal", 2.0, 0xFFFFFF),
        VAMPIRE_KILLER("vampire_killer", 0.5, 7995507),
        SPITFIRE("spitfire", 0.5, 0xFF2211),
        TELEPORT("teleport", 0.5, 740674);

        public final int color;
        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage, int color) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
        }

        @NotNull
        public String getName() {
            return this.m_7912_();
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

