/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PureBloodItem
extends Item {
    public static final int COUNT = 5;
    private static final Logger LOGGER = LogManager.getLogger();
    private final int level;
    private String descriptionId;

    @NotNull
    public static Item getBloodItemForLevel(int level) {
        return switch (level) {
            case 0 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_0.get());
            case 1 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_1.get());
            case 2 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_2.get());
            case 3 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_3.get());
            case 4 -> (PureBloodItem)((Object)ModItems.PURE_BLOOD_4.get());
            default -> {
                LOGGER.warn("Pure blood of level {} does not exist", (Object)level);
                yield (PureBloodItem)((Object)ModItems.PURE_BLOOD_4.get());
            }
        };
    }

    public PureBloodItem(int level) {
        super(new Item.Properties());
        this.level = level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.vampirism.pure_blood.purity").m_7220_((Component)Component.m_237113_((String)(": " + (this.level + 1) + "/5"))).m_130940_(ChatFormatting.RED));
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            VampirePlayer.getOpt((Player)entityLiving).ifPresent(v -> {
                v.drinkBlood(50, 0.3f, false);
                entityLiving.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SATURATION.get()));
                stack.m_41774_(1);
            });
        }
        return stack;
    }

    public int getLevel() {
        return this.level;
    }

    @NotNull
    public Component getCustomName() {
        return Component.m_237115_((String)this.m_41467_()).m_7220_((Component)Component.m_237113_((String)(" " + (this.level + 1))));
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 30;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        int playerLevel = VampirismAPI.getFactionPlayerHandler(playerIn).map(fph -> fph.getCurrentLevel(VReference.VAMPIRE_FACTION)).orElse(0);
        if (VampireLevelingConf.getInstance().isLevelValidForAltarInfusion(playerLevel)) {
            int pureLevel = VampireLevelingConf.getInstance().getAltarInfusionRequirements(playerLevel).pureBloodLevel();
            if (this.getLevel() < pureLevel) {
                playerIn.m_6672_(handIn);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @NotNull
    protected String m_41467_() {
        if (this.descriptionId == null) {
            this.descriptionId = super.m_41467_().replaceAll("_\\d", "");
        }
        return this.descriptionId;
    }
}

