/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.items.VampirismSwordItem;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.ToolMaterial;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampirismVampireSwordItem
extends VampirismSwordItem
implements IBloodChargeable,
IFactionExclusiveItem,
IFactionLevelItem<IVampirePlayer> {
    public static final String DO_NOT_NAME_STRING = "DO_NOT_NAME";
    private static final float minStrength = 0.2f;
    private final float trainedAttackSpeedIncrease;

    public VampirismVampireSwordItem(@NotNull VampireSwordMaterial material, int attackDamage, @NotNull Item.Properties prop) {
        super(material, attackDamage, material.m_6624_(), prop);
        this.trainedAttackSpeedIncrease = material.getTrainedSpeedIncrease();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        float charged = this.getCharged(stack);
        float trained = this.getTrained(stack, (LivingEntity)VampirismMod.proxy.getClientPlayer());
        tooltip.add((Component)Component.m_237115_((String)"text.vampirism.sword_charged").m_7220_((Component)Component.m_237113_((String)(" " + (int)Math.ceil(charged * 100.0f) + "%"))).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)Component.m_237115_((String)"text.vampirism.sword_trained").m_7220_((Component)Component.m_237113_((String)(" " + (int)Math.ceil(trained * 100.0f) + "%"))).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44981_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean canBeCharged(@NotNull ItemStack stack) {
        return this.getCharged(stack) < 1.0f;
    }

    @Override
    public int charge(@NotNull ItemStack stack, int amount) {
        float factor = this.getChargingFactor(stack);
        float charge = this.getCharged(stack);
        float actual = Math.min(factor * (float)amount, 1.0f - charge);
        this.setCharged(stack, charge + actual);
        return (int)(actual / factor);
    }

    public void doNotName(@NotNull ItemStack stack) {
        stack.m_41700_("dont_name", (Tag)ByteTag.m_128266_((byte)127));
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public ISkill<IVampirePlayer> getRequiredSkill(@NotNull ItemStack stack) {
        return null;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 40;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        VReference.VAMPIRE_FACTION.getPlayerCapability((Player)entityLiving).ifPresent(vampire -> {
            int amount;
            int n = amount = vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.BLOOD_CHARGE_SPEED.get()) ? (Integer)VampirismConfig.BALANCE.vrBloodChargeSpeedMod.get() : 2;
            if (((Player)entityLiving).m_7500_() || vampire.useBlood(amount, false)) {
                this.charge(stack, amount * 100);
            }
        });
        if (this.getCharged(stack) == 1.0f) {
            this.tryName(stack, (Player)entityLiving);
        }
        return stack;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        if (attacker instanceof Player) {
            double relTh;
            Player player = (Player)attacker;
            if (!Helper.isVampire((Entity)target) && (relTh = (Double)VampirismConfig.BALANCE.vsSwordFinisherMaxHealth.get() * VampirePlayer.getOpt(player).map(VampirePlayer::getSkillHandler).map(h -> h.isSkillEnabled((ISkill)VampireSkills.SWORD_FINISHER.get()) ? (h.isRefinementEquipped((IRefinement)ModRefinements.SWORD_FINISHER.get()) ? (Double)VampirismConfig.BALANCE.vrSwordFinisherThresholdMod.get() : 1.0) : 0.0).orElse(0.0)) > 0.0 && (double)target.m_21223_() <= (double)target.m_21233_() * relTh) {
                DamageHandler.hurtModded((Entity)target, s -> s.getPlayerAttackWithBypassArmor(player), 10000.0f);
                Vec3 center = Vec3.m_82528_((Vec3i)target.m_20183_());
                center.m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0);
                ModParticles.spawnParticlesServer(target.f_19853_, new GenericParticleOptions(new ResourceLocation("minecraft", "effect_4"), 12, 0xE02020), center.f_82479_, center.f_82480_, center.f_82481_, 15, 0.5, 0.5, 0.5, 0.0);
            }
        }
        if (target.m_21223_() <= 0.0f && Helper.isVampire((Entity)attacker)) {
            float trained = this.getTrained(stack, attacker);
            int exp = target instanceof Player ? 10 : (attacker instanceof Player ? Helper.getExperiencePoints(target, (Player)attacker) : 5);
            float newTrained = (float)exp / 5.0f * (1.0f - trained) / 15.0f;
            if (attacker instanceof Player && VampirePlayer.getOpt((Player)attacker).map(VampirePlayer::getSkillHandler).map(handler -> handler.isRefinementEquipped((IRefinement)ModRefinements.SWORD_TRAINED_AMOUNT.get())).orElse(false).booleanValue()) {
                newTrained = (float)((double)newTrained * (Double)VampirismConfig.BALANCE.vrSwordTrainingSpeedMod.get());
            }
            this.setTrained(stack, attacker, trained += newTrained);
        }
        float charged = this.getCharged(stack);
        this.setCharged(stack, charged -= this.getChargeUsage());
        attacker.m_21008_(InteractionHand.MAIN_HAND, stack);
        return super.m_7579_(stack, target, attacker);
    }

    public boolean isFullyCharged(@NotNull ItemStack stack) {
        return this.getCharged(stack) == 1.0f;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return !Helper.isVampire((Entity)entity);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        float charged;
        if (worldIn.f_46443_ && (isSelected || itemSlot == 0) && (charged = this.getCharged(stack)) > 0.0f && entityIn.f_19797_ % (int)(20.0f + 100.0f * (1.0f - charged)) == 0 && entityIn instanceof LivingEntity) {
            boolean secondHand;
            boolean bl = secondHand = !isSelected && ((LivingEntity)entityIn).m_21120_(InteractionHand.OFF_HAND).equals(stack);
            if (isSelected || secondHand) {
                this.spawnChargedParticle((LivingEntity)entityIn, isSelected);
            }
        }
    }

    public void onUsingTick(ItemStack stack, @NotNull LivingEntity player, int count) {
        if (player.m_20193_().f_46443_ && count % 3 == 0) {
            this.spawnChargingParticle(player, player.m_21205_().equals(stack));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return !Helper.isVampire(player);
    }

    public void setCharged(@NotNull ItemStack stack, float value) {
        stack.m_41700_("charged", (Tag)FloatTag.m_128566_((float)Mth.m_14036_((float)value, (float)0.0f, (float)1.0f)));
    }

    public void setTrained(@NotNull ItemStack stack, @NotNull LivingEntity player, float value) {
        CompoundTag nbt = stack.m_41698_("trained");
        nbt.m_128350_(player.m_20148_().toString(), Mth.m_14036_((float)value, (float)0.0f, (float)1.0f));
    }

    public void tryName(@NotNull ItemStack stack, @NotNull Player player) {
        if (!(stack.m_41788_() || !player.f_19853_.m_5776_() || stack.m_41782_() && stack.m_41783_().m_128471_("dont_name"))) {
            VampirismMod.proxy.displayNameSwordScreen(stack);
            player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public boolean updateTrainedCached(@NotNull ItemStack stack, @NotNull LivingEntity player) {
        float trained;
        float cached = this.getTrained(stack);
        if (cached != (trained = this.getTrained(stack, player))) {
            stack.m_41700_("trained-cache", (Tag)FloatTag.m_128566_((float)trained));
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return VampirePlayer.getOpt(playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (this.canBeCharged(stack) && playerIn.m_6144_() && vampire.getSkillHandler().isSkillEnabled((ISkill)VampireSkills.BLOOD_CHARGE.get()) && (playerIn.m_7500_() || vampire.getBloodLevel() >= (vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.BLOOD_CHARGE_SPEED.get()) ? (Integer)VampirismConfig.BALANCE.vrBloodChargeSpeedMod.get() : 2))) {
                playerIn.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)stack));
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.m_43299_() + this.getAttackDamageModifier(stack)), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)(this.m_43314_().m_6624_() + this.getSpeedModifier(stack)), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamageModifier(@NotNull ItemStack stack) {
        return this.getCharged(stack) > 0.0f ? 1.0f : 0.2f;
    }

    protected float getSpeedModifier(@NotNull ItemStack stack) {
        return this.getTrained(stack) * this.trainedAttackSpeedIncrease;
    }

    protected abstract float getChargeUsage();

    protected float getCharged(@NotNull ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128457_("charged");
        }
        return 0.0f;
    }

    protected abstract float getChargingFactor(ItemStack var1);

    protected float getTrained(@NotNull ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("trained-cache")) {
            return nbt.m_128457_("trained-cache");
        }
        return 0.0f;
    }

    protected float getTrained(@NotNull ItemStack stack, @Nullable LivingEntity player) {
        if (player == null) {
            return this.getTrained(stack);
        }
        UUID id = player.m_20148_();
        CompoundTag nbt = stack.m_41737_("trained");
        if (nbt != null && nbt.m_128441_(id.toString())) {
            return nbt.m_128457_(id.toString());
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargedParticle(@NotNull LivingEntity player, boolean mainHand) {
        Vec3 mainPos = UtilLib.getItemPosition(player, mainHand);
        for (int j = 0; j < 3; ++j) {
            Vec3 pos = mainPos.m_82520_((double)((player.m_217043_().m_188501_() - 0.5f) * 0.1f), (double)((player.m_217043_().m_188501_() - 0.3f) * 0.9f), (double)((player.m_217043_().m_188501_() - 0.5f) * 0.1f));
            ModParticles.spawnParticleClient(player.m_20193_(), new FlyingBloodParticleOptions((int)(4.0f / (player.m_217043_().m_188501_() * 0.9f + 0.1f)), true, pos.f_82479_ + ((double)player.m_217043_().m_188501_() - 0.5) * 0.1, pos.f_82480_ + ((double)player.m_217043_().m_188501_() - 0.5) * 0.1, pos.f_82481_ + ((double)player.m_217043_().m_188501_() - 0.5) * 0.1, new ResourceLocation("minecraft", "glitter_1")), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargingParticle(@NotNull LivingEntity player, boolean mainHand) {
        Vec3 pos = UtilLib.getItemPosition(player, mainHand);
        if (player.m_21324_(1.0f) > 0.0f) {
            return;
        }
        pos = pos.m_82520_((double)((player.m_217043_().m_188501_() - 0.5f) * 0.1f), (double)((player.m_217043_().m_188501_() - 0.3f) * 0.9f), (double)((player.m_217043_().m_188501_() - 0.5f) * 0.1f));
        Vec3 playerPos = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_() - (double)0.2f, player.m_20189_());
        ModParticles.spawnParticleClient(player.m_20193_(), new FlyingBloodParticleOptions((int)(4.0f / (player.m_217043_().m_188501_() * 0.6f + 0.1f)), true, pos.f_82479_, pos.f_82480_, pos.f_82481_), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_);
    }

    public static class VampireSwordMaterial
    extends ToolMaterial.Tiered {
        private final float trainedSpeedIncrease;

        public VampireSwordMaterial(IItemWithTier.TIER tier, int level, int uses, float speed, float damage, int enchantmentValue, Supplier<Ingredient> repairIngredient, float trainedSpeedIncrease) {
            super(tier, level, uses, speed, damage, enchantmentValue, repairIngredient);
            this.trainedSpeedIncrease = trainedSpeedIncrease;
        }

        public float getTrainedSpeedIncrease() {
            return this.trainedSpeedIncrease;
        }
    }
}

