/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.oil;

import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EffectWeaponOil
extends WeaponOil {
    @NotNull
    private final MobEffect effect;
    @NotNull
    private final Supplier<Integer> effectDuration;

    public EffectWeaponOil(@NotNull MobEffect effect, @NotNull Supplier<Integer> effectDuration, int maxDuration) {
        super(effect.m_19484_(), maxDuration);
        this.effect = Objects.requireNonNull(effect);
        this.effectDuration = Objects.requireNonNull(effectDuration);
    }

    public EffectWeaponOil(@NotNull MobEffect effect, int effectDuration, int maxDuration) {
        this(effect, () -> effectDuration, maxDuration);
    }

    @NotNull
    public MobEffect getEffect() {
        return this.effect;
    }

    @NotNull
    public MobEffectInstance getEffectInstance() {
        return new MobEffectInstance(this.effect, this.effectDuration.get().intValue());
    }

    @Override
    public float onHit(ItemStack stack, float amount, IWeaponOil oil, @NotNull LivingEntity target, LivingEntity source) {
        target.m_7292_(this.getEffectInstance());
        return 0.0f;
    }

    @Override
    public void getDescription(ItemStack stack, @NotNull List<Component> tooltips) {
        tooltips.add((Component)Component.m_237119_());
        tooltips.add((Component)Component.m_237115_((String)"text.vampirism.oil.effect_on_hit").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltips.add(this.getEffectDescriptionWithDash(this.getEffectInstance()));
    }

    @NotNull
    private Component getEffectDescriptionWithDash(@NotNull MobEffectInstance instance) {
        MutableComponent component = Component.m_237115_((String)instance.m_19576_());
        if (instance.m_19564_() > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + instance.m_19564_()))});
        }
        if (instance.m_19557_() > 20) {
            component = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{component, MobEffectUtil.m_267641_((MobEffectInstance)instance, (float)1.0f)});
        }
        return Component.m_237113_((String)"- ").m_7220_((Component)component).m_130940_(this.effect.m_19483_().m_19497_());
    }
}

