/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.lib.util.UtilLib;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class PageTable
extends Page {
    private final List<String[]> lines;
    private final int[] width;
    private final MutableComponent headline;

    private PageTable(List<String[]> lines, int[] width, MutableComponent headline) {
        this.lines = lines;
        this.width = width;
        this.headline = headline;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(@NotNull PoseStack stack, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen guiBase, @NotNull Font fontRendererObj) {
        float charWidth = fontRendererObj.m_92895_("W");
        int y = guiTop + 12;
        int x = guiLeft + 39;
        if (this.headline != null) {
            fontRendererObj.m_92889_(stack, (Component)this.headline.m_130940_(ChatFormatting.BOLD), (float)x, (float)y, 0);
            Objects.requireNonNull(fontRendererObj);
            y += 9;
        }
        double d = x;
        Objects.requireNonNull(fontRendererObj);
        double d2 = y + 9;
        double d3 = (float)x + (float)guiBase.xSize * 3.0f / 5.0f;
        Objects.requireNonNull(fontRendererObj);
        this.drawLine(stack, d, d2, d3, y + 9, 0.0f);
        for (String[] l : this.lines) {
            x = guiLeft + 39;
            for (int i = 0; i < l.length; ++i) {
                int mw = (int)((float)this.width[i] * charWidth);
                int aw = fontRendererObj.m_92895_(l[i]);
                int dw = (mw - aw) / 2;
                fontRendererObj.m_92883_(stack, l[i], (float)(x + dw), (float)y, 0);
                x += mw;
            }
            Objects.requireNonNull(fontRendererObj);
            y += 9;
        }
    }

    protected void drawLine(@NotNull PoseStack stack, double x1, double y1, double x2, double y2, float publicZLevel) {
        stack.m_85836_();
        Matrix4f matrix = stack.m_85850_().m_252922_();
        GL11.glDisable((int)3553);
        RenderSystem.m_69832_((float)2.0f);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        builder.m_252986_(matrix, (float)x1, (float)y1, publicZLevel).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, publicZLevel).m_6122_(0, 0, 0, 255).m_5752_();
        Tesselator.m_85913_().m_85914_();
        GL11.glEnable((int)3553);
        stack.m_85849_();
    }

    public static class Builder {
        int columns;
        List<String[]> lines;
        MutableComponent headline;

        public Builder(int columns) {
            this.columns = columns;
            this.lines = new ArrayList<String[]>();
        }

        @NotNull
        public Builder addLine(Object ... objects) {
            if (objects.length != this.columns) {
                throw new IllegalArgumentException("Every added line as to contain one String for every column");
            }
            String[] l = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                l[i] = String.valueOf(objects[i]);
            }
            this.lines.add(l);
            return this;
        }

        public Builder addUnlocLine(String ... strings) {
            String[] loc = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                loc[i] = UtilLib.translate(strings[i], new Object[0]);
            }
            return this.addLine(loc);
        }

        @NotNull
        public PageTable build() {
            int[] width = new int[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                int max = 0;
                for (String[] s : this.lines) {
                    int w = s[i].length();
                    if (w <= max) continue;
                    max = w;
                }
                width[i] = max;
            }
            return new PageTable(this.lines, width, this.headline);
        }

        @NotNull
        public Builder setHeadline(MutableComponent s) {
            this.headline = s;
            return this;
        }
    }
}

