/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BasicWeaponTableRecipeRenderer<T extends IWeaponTableRecipe>
extends IRecipeRenderer.RecipeRendererBase<T> {
    private final SubTexture CRAFTING_GRID = new SubTexture(new ResourceLocation("vampirismguide", "textures/gui/weapon_table_recipe.png"), 0, 0, 110, 75);

    public BasicWeaponTableRecipeRenderer(T recipe) {
        super(recipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(@NotNull PoseStack stack, RegistryAccess registryAccess, Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen baseScreen, @NotNull Font fontRenderer, IngredientCycler ingredientCycler) {
        this.CRAFTING_GRID.draw(stack, guiLeft + 62, guiTop + 43);
        baseScreen.drawCenteredStringWithoutShadow(stack, fontRenderer, (Component)((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).m_49954_(), guiLeft + baseScreen.xSize / 2, guiTop + 12, 0);
        MutableComponent mutableComponent = this.getRecipeName().m_130938_(style -> style.m_131155_(Boolean.valueOf(true)));
        int n = guiLeft + baseScreen.xSize / 2;
        Objects.requireNonNull(fontRenderer);
        baseScreen.drawCenteredStringWithoutShadow(stack, fontRenderer, (Component)mutableComponent, n, guiTop + 14 + 9, 0);
        int outputX = guiLeft + 152;
        int outputY = guiTop + 72;
        ItemStack itemStack = ((IWeaponTableRecipe)this.recipe).m_8043_(registryAccess);
        GuiHelper.drawItemStack((PoseStack)stack, (ItemStack)itemStack, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)((IWeaponTableRecipe)this.recipe).m_8043_(registryAccess));
        }
        if (((IWeaponTableRecipe)this.recipe).getRequiredLavaUnits() > 0) {
            GuiHelper.drawItemStack((PoseStack)stack, (ItemStack)new ItemStack((ItemLike)Items.f_42448_), (int)(outputX - 16), (int)(outputY + 21));
        }
        int y = guiTop + 120;
        if (((IWeaponTableRecipe)this.recipe).getRequiredLevel() > 1) {
            MutableComponent level = Component.m_237110_((String)"gui.vampirism.hunter_weapon_table.level", (Object[])new Object[]{((IWeaponTableRecipe)this.recipe).getRequiredLevel()});
            fontRenderer.m_92889_(stack, (Component)level, (float)(guiLeft + 40), (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(fontRenderer);
            y += 9 + 2;
        }
        if (((IWeaponTableRecipe)this.recipe).getRequiredSkills().length > 0) {
            MutableComponent newLine = Component.m_237113_((String)"\n");
            ArrayList<MutableComponent> skills = new ArrayList<MutableComponent>();
            skills.add(Component.m_237110_((String)"gui.vampirism.skill_required", (Object[])new Object[]{"\n"}));
            for (ISkill<IHunterPlayer> skill : ((IWeaponTableRecipe)this.recipe).getRequiredSkills()) {
                skills.add(skill.getName().m_6881_().m_130940_(ChatFormatting.ITALIC));
                skills.add(newLine);
            }
            fontRenderer.m_274535_(stack, FormattedText.m_130768_(skills), guiLeft + 40, y, 110, Color.GRAY.getRGB());
        }
    }

    protected MutableComponent getRecipeName() {
        return Component.m_237115_((String)"guideapi.text.crafting.shaped");
    }
}

