/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public record ClientboundBloodValuePacket(Map<ResourceLocation, Float>[] values) implements IMessage.IClientBoundMessage
{
    static void encode(@NotNull ClientboundBloodValuePacket msg, @NotNull FriendlyByteBuf buf) {
        for (Map<ResourceLocation, Float> e : msg.values) {
            buf.m_130130_(e.size());
            for (Map.Entry<ResourceLocation, Float> f : e.entrySet()) {
                buf.m_130085_(f.getKey());
                buf.writeFloat(f.getValue().floatValue());
            }
        }
    }

    @NotNull
    static ClientboundBloodValuePacket decode(@NotNull FriendlyByteBuf buf) {
        Map[] values = (Map[])Array.newInstance(Map.class, 3);
        for (int i = 0; i < 3; ++i) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int z = buf.m_130242_();
            for (int u = 0; u < z; ++u) {
                builder.put((Object)buf.m_130281_(), (Object)Float.valueOf(buf.readFloat()));
            }
            values[i] = builder.build();
        }
        return new ClientboundBloodValuePacket(values);
    }

    public static void handle(ClientboundBloodValuePacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleBloodValuePacket(msg));
        ctx.setPacketHandled(true);
    }

    public Map<ResourceLocation, Float>[] getValues() {
        return this.values;
    }
}

