/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public record ServerboundAppearancePacket(int entityId, String name, int[] data) implements IMessage.IServerBoundMessage
{
    static void encode(@NotNull ServerboundAppearancePacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130070_(msg.name);
        buf.m_130130_(msg.data.length);
        for (int value : msg.data) {
            buf.m_130130_(value);
        }
    }

    @NotNull
    static ServerboundAppearancePacket decode(@NotNull FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        String newName = buf.m_130136_(15);
        int[] data = new int[buf.m_130242_()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buf.m_130242_();
        }
        return new ServerboundAppearancePacket(entityId, newName, data);
    }

    public static void handle(@NotNull ServerboundAppearancePacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            Entity entity = ctx.getSender().f_19853_.m_6815_(msg.entityId);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                VampirePlayer.getOpt(player).ifPresent(vampire -> vampire.setSkinData(msg.data));
            } else if (entity instanceof MinionEntity) {
                MinionEntity minion = (MinionEntity)entity;
                minion.getMinionData().ifPresent(minionData -> minionData.handleMinionAppearanceConfig(msg.name, msg.data));
                HelperLib.sync(minion);
            }
        });
        ctx.setPacketHandled(true);
    }
}

