/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.sit;

import de.teamlapen.vampirism.sit.SitEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, Pair<SitEntity, BlockPos>>>();

    public static boolean addSitEntity(@NotNull Level level, BlockPos blockPos, SitEntity entity, BlockPos playerPos) {
        if (!level.f_46443_ && playerPos != null) {
            ResourceLocation id = SitUtil.getDimensionTypeId(level);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            OCCUPIED.get(id).put(blockPos, (Pair<SitEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(@NotNull Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(level))) {
            OCCUPIED.get(id).remove(pos).getLeft();
            return true;
        }
        return false;
    }

    @Nullable
    public static SitEntity getSitEntity(@NotNull Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(level)) && OCCUPIED.get(id).containsKey(pos)) {
            return (SitEntity)((Object)OCCUPIED.get(id).get(pos).getLeft());
        }
        return null;
    }

    @Nullable
    public static BlockPos getPreviousPlayerPosition(@NotNull Player player, SitEntity sitEntity) {
        ResourceLocation id;
        if (!player.f_19853_.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(player.f_19853_))) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(id).values()) {
                if (pair.getLeft() != sitEntity) continue;
                return (BlockPos)pair.getRight();
            }
        }
        return null;
    }

    public static boolean isOccupied(@NotNull Level world, BlockPos pos) {
        ResourceLocation id = SitUtil.getDimensionTypeId(world);
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(@NotNull Player player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (Pair<SitEntity, BlockPos> pair : OCCUPIED.get(i).values()) {
                if (!((SitEntity)((Object)pair.getLeft())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static ResourceLocation getDimensionTypeId(@NotNull Level level) {
        return level.m_46472_().m_135782_();
    }
}

