/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tests;

import com.google.common.base.Stopwatch;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.fluids.BloodHelper;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tests {
    private static final Logger LOGGER = LogManager.getLogger(Tests.class);

    public static void runTests(@NotNull Level world, @NotNull ServerPlayer player) {
        Tests.sendMsg((Player)player, "Starting tests");
        LOGGER.warn("Clearing area", new Object[0]);
        Tests.clearArea(world);
        boolean wasCreative = player.m_7500_();
        player.m_143403_(GameType.SURVIVAL);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 100));
        player.m_20984_(0.0, 5.0, 0.0, true);
        TestInfo info = new TestInfo(world, (Player)player, new BlockPos(-20, 2, -20), "BloodFluidHandler");
        Tests.runTest(Tests::bloodFluidHandler, info);
        Tests.runTest(Tests::blockWeaponTableFluids, info.next("BlockWeaponTableFluids"));
        LOGGER.warn("Finished tests -> teleporting player", new Object[0]);
        player.m_20984_(0.0, 5.0, 0.0, true);
        if (wasCreative) {
            player.m_143403_(GameType.CREATIVE);
        }
        Tests.sendMsg((Player)player, "Finished tests");
    }

    private static void runTest(@NotNull Tester tester, @NotNull TestInfo info) {
        boolean result;
        try {
            result = tester.run(info);
        }
        catch (Throwable t) {
            LOGGER.warn(info.name + " failed with exception %s", new Object[]{t});
            result = false;
        }
        Tests.sendMsg(info.player, info.name + " test " + (result ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
    }

    private static void runLightTest(@NotNull LightTester tester, String name, @Nullable Player player) {
        boolean result;
        try {
            result = tester.run();
        }
        catch (Throwable t) {
            LOGGER.warn(name + " failed with exception {}", new Object[]{t});
            result = false;
        }
        if (player != null) {
            Tests.sendMsg(player, name + " test " + (result ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
        } else {
            String msg = name + "test " + (result ? "was successful" : "failed");
            LOGGER.warn(msg, new Object[0]);
        }
    }

    public static void runBackgroundTests() {
        LOGGER.warn("Running background tests", new Object[0]);
        Stopwatch w = Stopwatch.createStarted();
        LOGGER.warn("Finished background tests after {} ms", new Object[]{w.stop().elapsed(TimeUnit.MILLISECONDS)});
    }

    private static boolean bloodFluidHandler(@NotNull TestInfo info) {
        info.world.m_46597_(info.pos, ((BloodContainerBlock)ModBlocks.BLOOD_CONTAINER.get()).m_49966_());
        BlockEntity t = info.world.m_7702_(info.pos);
        LazyOptional opt = t.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.m_235672_((RandomSource)info.world.f_46441_));
        opt.ifPresent(handler -> handler.fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), 10000000), IFluidHandler.FluidAction.EXECUTE));
        int blood = BloodHelper.getBlood((LazyOptional<IFluidHandler>)opt);
        assert (blood > 0) : "Could not fill blood container";
        ItemStack bloodBottle1 = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get());
        ItemStack bloodBottle2 = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get());
        IFluidHandler handler2 = (IFluidHandler)opt.orElse(null);
        FluidActionResult result1 = FluidUtil.tryFillContainer((ItemStack)bloodBottle1, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result1.isSuccess()) : "Transaction 1 failed";
        bloodBottle1 = result1.getResult();
        FluidActionResult result2 = FluidUtil.tryFillContainer((ItemStack)bloodBottle2, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result2.isSuccess()) : "Transaction 2 failed";
        bloodBottle2 = result2.getResult();
        assert (BloodHelper.getBlood(handler2) < blood) : "Failed to drain from container into bottles";
        FluidActionResult result3 = FluidUtil.tryEmptyContainer((ItemStack)bloodBottle1, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result3.isSuccess()) : "Transaction 3 failed";
        bloodBottle1 = result3.getResult();
        FluidActionResult result4 = FluidUtil.tryEmptyContainer((ItemStack)bloodBottle2, (IFluidHandler)handler2, (int)Integer.MAX_VALUE, null, (boolean)true);
        assert (result4.isSuccess()) : "Transaction 4 failed";
        bloodBottle2 = result4.getResult();
        LOGGER.warn("{} {}", new Object[]{BloodHelper.getBlood(handler2), blood});
        assert (BloodHelper.getBlood(handler2) == blood) : "Lost blood somewhere";
        return true;
    }

    private static boolean blockWeaponTableFluids(@NotNull TestInfo info) {
        info.world.m_46597_(info.pos, ((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).m_49966_());
        info.player.m_21008_(info.player.m_7655_(), new ItemStack((ItemLike)Items.f_42448_));
        BlockState block = info.world.m_8055_(info.pos);
        block.m_60664_(info.world, info.player, info.player.m_7655_(), new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.m_235672_((RandomSource)info.world.f_46441_), info.pos, false));
        block = info.world.m_8055_(info.pos);
        assert (info.player.m_21120_(info.player.m_7655_()).m_41720_().equals(Items.f_42446_)) : "Incorrect Fluid Container Handling";
        LOGGER.warn("Block lava level: {}", new Object[]{block.m_61143_((Property)WeaponTableBlock.LAVA)});
        assert ((Integer)block.m_61143_((Property)WeaponTableBlock.LAVA) * 200 == 1000) : "Incorrect Fluid Transaction";
        return true;
    }

    private static void sendMsg(@NotNull Player player, String msg) {
        player.m_5661_((Component)Component.m_237113_((String)("\u00a71[V-TEST]\u00a7r " + msg)), false);
    }

    private static void clearArea(@NotNull Level world) {
        for (int x = -21; x < 22; ++x) {
            for (int y = 1; y < 22; ++y) {
                for (int z = -21; z < 22; ++z) {
                    BlockState s = y == 1 || x == -21 || x == 21 || z == -21 || z == 21 || y == 21 ? ((CastleBricksBlock)((Object)ModBlocks.CASTLE_BLOCK_DARK_STONE.get())).m_49966_() : Blocks.f_50016_.m_49966_();
                    world.m_46597_(new BlockPos(x, y, z), s);
                }
            }
        }
    }

    private static class TestInfo {
        final Level world;
        final Player player;
        BlockPos pos;
        String name;

        private TestInfo(Level world, Player player, BlockPos pos, String name) {
            this.world = world;
            this.player = player;
            this.pos = pos;
            this.name = name;
        }

        @NotNull
        private TestInfo next(String name) {
            int x = this.pos.m_123341_();
            int z = this.pos.m_123343_();
            if ((x += 5) > 20) {
                x = -20;
                if ((z += 5) > 20) {
                    throw new IllegalStateException("Not enough room -> Too many tests");
                }
            }
            this.pos = new BlockPos(x, this.pos.m_123342_(), z);
            this.name = name;
            return this;
        }
    }

    @FunctionalInterface
    private static interface Tester {
        public Boolean run(TestInfo var1) throws Throwable;
    }

    @FunctionalInterface
    private static interface LightTester {
        public Boolean run() throws Throwable;
    }
}

