/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.ModDamageSources;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DamageHandler {
    public static void affectVampireGarlicSplash(@NotNull IVampire vampire, @NotNull EnumStrength strength, double distSq, boolean directHit) {
        if (vampire.doesResistGarlic(strength)) {
            return;
        }
        if (distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            DamageHandler.affectVampireGarlic(vampire, strength, (float)(10.0 * affect), false);
        }
    }

    public static void affectVampireGarlicDirect(@NotNull IVampire vampire, @NotNull EnumStrength strength) {
        DamageHandler.affectVampireGarlic(vampire, strength, 20.0f, false);
    }

    private static void affectVampireGarlic(@NotNull IVampire vampire, @NotNull EnumStrength strength, float multiplier, boolean ambient) {
        if (strength == EnumStrength.NONE) {
            return;
        }
        LivingEntity entity = vampire.getRepresentingEntity();
        entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.GARLIC.get(), (int)(multiplier * 20.0f), strength.getStrength() - 1, ambient, true));
        if (entity instanceof Player && ((Player)entity).m_150110_().f_35937_) {
            return;
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, (int)(multiplier * 20.0f), 1, ambient, false));
        if (strength == EnumStrength.MEDIUM || strength == EnumStrength.STRONG) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(multiplier * 20.0f), 1, ambient, false));
            if (strength == EnumStrength.STRONG) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, (int)(multiplier / 2.0f * 20.0f), 0, ambient, false));
            }
        }
        if (vampire instanceof IVampirePlayer) {
            IActionHandler<IVampirePlayer> actionHandler = ((IVampirePlayer)vampire).getActionHandler();
            actionHandler.deactivateAction((ILastingAction)VampireActions.DISGUISE_VAMPIRE.get());
        }
    }

    public static void affectVampireGarlicAmbient(@NotNull IVampire vampire, @NotNull EnumStrength strength, int ticks) {
        if (ticks % 37 == 7) {
            DamageHandler.affectVampireGarlic(vampire, strength, 5.0f, true);
        }
    }

    public static void affectEntityHolyWaterSplash(@NotNull LivingEntity entity, @NotNull EnumStrength strength, double distSq, boolean directHit) {
        DamageHandler.affectEntityHolyWaterSplash(entity, strength, distSq, directHit, null);
    }

    public static void affectEntityHolyWaterSplash(@NotNull LivingEntity entity, @NotNull EnumStrength strength, double distSq, boolean directHit, @Nullable LivingEntity source) {
        IActionHandlerEntity h;
        if (!entity.m_6084_()) {
            return;
        }
        boolean vampire = Helper.isVampire((Entity)entity);
        if (entity.m_5801_() && (vampire || MobType.f_21641_.equals(entity.m_6336_())) && distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            if (!vampire) {
                affect *= 0.5;
            }
            double amount = affect * ((double)((Integer)VampirismConfig.BALANCE.holyWaterSplashDamage.get()).intValue() * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() : (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get() * (Double)VampirismConfig.BALANCE.holyWaterTierDamageInc.get()))) + 0.5;
            if (entity instanceof Player) {
                int l = VampirismPlayerAttributes.get((Player)((Player)entity)).vampireLevel;
                amount = DamageHandler.scaleDamageWithLevel(l, 14, amount * 0.8, amount * 1.3);
            } else if (entity instanceof VampireBaronEntity) {
                int l = ((VampireBaronEntity)entity).getEntityLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, 4, amount * 0.8, amount * 2.0);
            }
            DamageHandler.hurtModded((Entity)entity, ModDamageSources::holyWater, (float)amount);
        }
        if (vampire && entity instanceof Player) {
            VampirePlayer.getOpt((Player)entity).map(VampirePlayer::getActionHandler).ifPresent(actionHandler -> {
                actionHandler.deactivateAction((ILastingAction)VampireActions.DISGUISE_VAMPIRE.get());
                actionHandler.deactivateAction((ILastingAction)VampireActions.VAMPIRE_INVISIBILITY.get());
            });
        } else if (vampire && entity instanceof IEntityActionUser && (h = ((IEntityActionUser)entity).getActionHandler()).isActionActive((IEntityAction)EntityActions.ENTITY_INVISIBLE.get())) {
            h.deactivateAction();
        }
        if (vampire) {
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, ((Integer)VampirismConfig.BALANCE.holyWaterNauseaDuration.get()).intValue(), 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, ((Integer)VampirismConfig.BALANCE.holyWaterBlindnessDuration.get()).intValue(), 1));
            }
        }
    }

    public static double scaleDamageWithLevel(int level, int maxLevel, double minDamage, double maxDamage) {
        return minDamage + (double)level / (double)maxLevel * (maxDamage - minDamage);
    }

    @NotNull
    public static Optional<DamageSource> getDamageSource(@NotNull Level world, @NotNull Function<ModDamageSources, DamageSource> sourceFunc) {
        return VampirismWorld.getOpt(world).map(VampirismWorld::damageSources).map(sourceFunc);
    }

    public static boolean hurtModded(@NotNull Entity entity, @NotNull Function<ModDamageSources, DamageSource> sourceFunc, float amount) {
        return DamageHandler.getDamageSource(entity.f_19853_, sourceFunc).map(source -> entity.m_6469_(source, amount)).orElse(false);
    }

    public static boolean hurtVanilla(@NotNull Entity entity, @NotNull Function<DamageSources, DamageSource> sourceFunc, float amount) {
        DamageSource source = sourceFunc.apply(entity.f_19853_.m_269111_());
        return entity.m_6469_(source, amount);
    }

    public static boolean kill(@NotNull Entity entity, int damage) {
        return DamageHandler.hurtVanilla(entity, DamageSources::m_269264_, damage);
    }
}

