/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.items.CrossbowArrowItem;
import de.teamlapen.vampirism.items.StakeItem;
import de.teamlapen.vampirism.mixin.LivingEntityAccessor;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Helper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation EMPTY_ID = new ResourceLocation("null", "null");
    private static Method reflectionMethodExperiencePoints;

    public static boolean gettingSundamge(LivingEntity entity, LevelAccessor world, @Nullable ProfilerFiller profiler) {
        BlockPos pos;
        float angle;
        if (profiler != null) {
            profiler.m_6180_("vampirism_checkSundamage");
        }
        if (entity instanceof Player && entity.m_5833_()) {
            return false;
        }
        ResourceKey<Level> worldKey = Helper.getWorldKey(world);
        if (VampirismAPI.sundamageRegistry().getSundamageInDim(worldKey) && (!(world instanceof Level) || !((Level)world).m_46471_()) && ((double)(angle = world.m_46942_(1.0f)) > 0.78 || (double)angle < 0.24) && Helper.canBlockSeeSun(world, pos = new BlockPos((int)entity.m_20185_(), (int)(entity.m_20186_() + (double)Mth.m_14036_((float)(entity.m_20206_() / 2.0f), (float)0.0f, (float)2.0f)), (int)entity.m_20189_()))) {
            try {
                ResourceLocation biome = Helper.getBiomeId((CommonLevelAccessor)world, pos);
                if (VampirismAPI.sundamageRegistry().getSundamageInBiome(biome) && world instanceof Level && !VampirismWorld.getOpt((Level)world).map(vw -> vw.isInsideArtificialVampireFogArea(new BlockPos((int)entity.m_20185_(), (int)(entity.m_20186_() + 1.0), (int)entity.m_20189_()))).orElse(false).booleanValue()) {
                    if (profiler != null) {
                        profiler.m_7238_();
                    }
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (profiler != null) {
            profiler.m_7238_();
        }
        return false;
    }

    public static boolean canBlockSeeSun(@NotNull LevelAccessor world, @NotNull BlockPos pos) {
        if (pos.m_123342_() >= world.m_5736_()) {
            return world.m_45527_(pos);
        }
        BlockPos blockpos = new BlockPos(pos.m_123341_(), world.m_5736_(), pos.m_123343_());
        if (!world.m_45527_(blockpos)) {
            return false;
        }
        int liquidBlocks = 0;
        blockpos = blockpos.m_7495_();
        while (blockpos.m_123342_() > pos.m_123342_()) {
            BlockState state = world.m_8055_(blockpos);
            if (state.m_60767_().m_76332_()) {
                if (++liquidBlocks >= (Integer)VampirismConfig.BALANCE.vpSundamageWaterblocks.get()) {
                    return false;
                }
            } else {
                if (state.m_60815_() && (state.m_60783_((BlockGetter)world, pos, Direction.DOWN) || state.m_60783_((BlockGetter)world, pos, Direction.UP))) {
                    return false;
                }
                if (state.m_60739_((BlockGetter)world, blockpos) > 0) {
                    return false;
                }
            }
            blockpos = blockpos.m_7495_();
        }
        return true;
    }

    @NotNull
    public static EnumStrength getGarlicStrength(@NotNull Entity e, LevelAccessor world) {
        return Helper.getGarlicStrengthAt(world, e.m_20183_());
    }

    @NotNull
    public static EnumStrength getGarlicStrengthAt(LevelAccessor world, @NotNull BlockPos pos) {
        return world instanceof Level ? VampirismAPI.getVampirismWorld((Level)world).map(vw -> vw.getStrengthAtChunk(new ChunkPos(pos))).orElse(EnumStrength.NONE) : EnumStrength.NONE;
    }

    @NotNull
    public static ResourceKey<Level> getWorldKey(LevelAccessor world) {
        return world instanceof Level ? ((Level)world).m_46472_() : (world instanceof ServerLevelAccessor ? ((ServerLevelAccessor)world).m_6018_().m_46472_() : Level.f_46428_);
    }

    public static boolean canBecomeVampire(@NotNull Player player) {
        return FactionPlayerHandler.getOpt(player).map(v -> v.canJoin(VReference.VAMPIRE_FACTION)).orElse(false);
    }

    public static boolean canTurnPlayer(IVampire biter, @Nullable Player target) {
        if (target != null && (target.m_7500_() || target.m_5833_())) {
            return false;
        }
        if (biter instanceof IVampirePlayer) {
            IVampirePlayer player = (IVampirePlayer)biter;
            if (!((Boolean)VampirismConfig.SERVER.playerCanTurnPlayer.get()).booleanValue()) {
                return false;
            }
            return !(player instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), Permissions.INFECT_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
        }
        return (Boolean)VampirismConfig.SERVER.disableMobBiteInfection.get() == false;
    }

    public static boolean isVampire(Entity entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Entity entity) {
        return VReference.HUNTER_FACTION.equals(VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isHunter(Player entity) {
        return VReference.HUNTER_FACTION.equals(VampirismPlayerAttributes.get((Player)entity).faction);
    }

    public static boolean isVampire(Player entity) {
        return VReference.VAMPIRE_FACTION.equals(VampirismPlayerAttributes.get((Player)entity).faction);
    }

    @SafeVarargs
    public static <T extends IFactionPlayer<T>> boolean areSkillsEnabled(@NotNull ISkillHandler<T> skillHandler, ISkill<T> ... skills) {
        if (skills == null) {
            return true;
        }
        for (ISkill<T> skill : skills) {
            if (skillHandler.isSkillEnabled(skill)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityInVampireBiome(@Nullable Entity e) {
        if (e == null) {
            return false;
        }
        Level w = e.m_20193_();
        return w.m_204166_(e.m_20183_()).m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME);
    }

    public static boolean isPosInVampireBiome(@NotNull BlockPos pos, @NotNull LevelAccessor level) {
        Holder biome = level.m_204166_(pos);
        return biome.m_203656_(ModTags.Biomes.IS_VAMPIRE_BIOME);
    }

    public static boolean isEntityInArtificalVampireFogArea(@Nullable Entity e) {
        if (e == null) {
            return false;
        }
        Level w = e.m_20193_();
        return VampirismWorld.getOpt(w).map(vh -> vh.isInsideArtificialVampireFogArea(e.m_20183_())).orElse(false);
    }

    public static ResourceLocation getBiomeId(@NotNull Entity e) {
        return Helper.getBiomeId((CommonLevelAccessor)e.m_20193_(), e.m_20183_());
    }

    public static ResourceLocation getBiomeId(@NotNull CommonLevelAccessor world, @NotNull BlockPos pos) {
        return Helper.getBiomeId(world, (Holder<Biome>)world.m_204166_(pos));
    }

    public static ResourceLocation getBiomeId(@NotNull CommonLevelAccessor world, @NotNull Holder<Biome> biome) {
        return (ResourceLocation)biome.m_203439_().map(ResourceKey::m_135782_, b -> world.m_9598_().m_175515_(Registries.f_256952_).m_7981_(b));
    }

    public static boolean canUseFactionItem(@NotNull ItemStack stack, @NotNull IFactionLevelItem<?> item, @NotNull IFactionPlayerHandler playerHandler) {
        IFaction<?> usingFaction = item.getExclusiveFaction(stack);
        ISkill<?> requiredSkill = item.getRequiredSkill(stack);
        int reqLevel = item.getMinLevel(stack);
        if (usingFaction != null && !playerHandler.isInFaction(usingFaction)) {
            return false;
        }
        if (playerHandler.getCurrentLevel() < reqLevel) {
            return false;
        }
        if (requiredSkill == null) {
            return true;
        }
        return playerHandler.getCurrentFactionPlayer().map(IFactionPlayer::getSkillHandler).map(s -> s.isSkillEnabled(requiredSkill)).orElse(false);
    }

    public static int getExperiencePoints(@NotNull LivingEntity entity, Player player) {
        return ((LivingEntityAccessor)entity).invokeGetExperiencePoints_vampirism();
    }

    public static boolean attemptToGuessGenderSafe(Player p) {
        Map textureMap;
        if (p instanceof ServerPlayer && (textureMap = ((ServerPlayer)p).f_8924_.m_129925_().getTextures(p.m_36316_(), false)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture skinTexture = (MinecraftProfileTexture)textureMap.get(MinecraftProfileTexture.Type.SKIN);
            return "slim".equals(skinTexture.getMetadata("model"));
        }
        return false;
    }

    @NotNull
    public static <T extends Entity> Optional<T> createEntity(@NotNull EntityType<T> type, @NotNull Level world) {
        Entity e = type.m_20615_(world);
        if (e == null) {
            LOGGER.warn("Failed to create entity of type {}", (Object)RegUtil.id(type));
            return Optional.empty();
        }
        return Optional.of(e);
    }

    @NotNull
    public static ListTag newDoubleNBTList(double ... numbers) {
        ListTag listnbt = new ListTag();
        for (double d0 : numbers) {
            listnbt.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listnbt;
    }

    public static boolean canKillVampires(@NotNull DamageSource source) {
        if (!source.m_269533_(DamageTypeTags.f_268738_) && ((List)VampirismConfig.BALANCE.vpImmortalFromDamageSources.get()).contains(source.m_19385_())) {
            if (source.m_7640_() instanceof LivingEntity) {
                return source.m_7640_() instanceof IHunterMob || ((LivingEntity)source.m_7640_()).m_21205_().m_41720_() instanceof StakeItem;
            }
            if (source.m_7640_() instanceof CrossbowArrowEntity) {
                return ((CrossbowArrowEntity)source.m_7640_()).getArrowType() == CrossbowArrowItem.EnumArrowType.VAMPIRE_KILLER;
            }
            return false;
        }
        return true;
    }
}

