/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class RegUtil {
    public static ResourceLocation id(@NotNull IAction<?> action) {
        return ModRegistries.ACTIONS.get().getKey(action);
    }

    public static ResourceLocation id(@NotNull ISkill<?> skill) {
        return ModRegistries.SKILLS.get().getKey(skill);
    }

    public static ResourceLocation id(@NotNull IMinionTask<?, ?> minionTask) {
        return ModRegistries.MINION_TASKS.get().getKey(minionTask);
    }

    public static ResourceLocation id(@NotNull IEntityAction entityAction) {
        return ModRegistries.ENTITY_ACTIONS.get().getKey((Object)entityAction);
    }

    public static ResourceLocation id(@NotNull Task skill) {
        return ModRegistries.TASKS.get().getKey((Object)skill);
    }

    public static ResourceLocation id(@NotNull IRefinement refinement) {
        return ModRegistries.REFINEMENTS.get().getKey((Object)refinement);
    }

    public static ResourceLocation id(@NotNull IRefinementSet refinementSet) {
        return ModRegistries.REFINEMENT_SETS.get().getKey((Object)refinementSet);
    }

    public static ResourceLocation id(@NotNull Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation id(@NotNull Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation id(@NotNull Fluid block) {
        return ForgeRegistries.FLUIDS.getKey((Object)block);
    }

    public static ResourceLocation id(@NotNull EntityType<?> type) {
        return ForgeRegistries.ENTITY_TYPES.getKey(type);
    }

    public static ResourceLocation id(@NotNull Biome type) {
        return ForgeRegistries.BIOMES.getKey((Object)type);
    }

    public static ResourceLocation id(@NotNull Enchantment type) {
        return ForgeRegistries.ENCHANTMENTS.getKey((Object)type);
    }

    public static ResourceLocation id(@NotNull VillagerProfession profession) {
        return ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)profession);
    }

    public static ResourceLocation id(@NotNull IOil oil) {
        return ModRegistries.OILS.get().getKey((Object)oil);
    }

    public static boolean has(@NotNull IAction<?> action) {
        return ModRegistries.ACTIONS.get().containsValue(action);
    }

    public static boolean has(@NotNull ISkill<?> skill) {
        return ModRegistries.SKILLS.get().containsValue(skill);
    }

    public static boolean has(@NotNull IMinionTask<?, ?> minionTask) {
        return ModRegistries.MINION_TASKS.get().containsValue(minionTask);
    }

    public static boolean has(@NotNull IEntityAction entityAction) {
        return ModRegistries.ENTITY_ACTIONS.get().containsValue((Object)entityAction);
    }

    public static boolean has(@NotNull Task skill) {
        return ModRegistries.TASKS.get().containsValue((Object)skill);
    }

    public static boolean has(@NotNull IRefinement refinement) {
        return ModRegistries.REFINEMENTS.get().containsValue((Object)refinement);
    }

    public static boolean has(@NotNull IRefinementSet refinementSet) {
        return ModRegistries.REFINEMENT_SETS.get().containsValue((Object)refinementSet);
    }

    public static boolean has(@NotNull Item item) {
        return ForgeRegistries.ITEMS.containsValue((Object)item);
    }

    public static boolean has(@NotNull Block block) {
        return ForgeRegistries.BLOCKS.containsValue((Object)block);
    }

    public static IAction<?> getAction(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.ACTIONS.get(), id);
    }

    public static ISkill<?> getSkill(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.SKILLS.get(), id);
    }

    public static IMinionTask<?, ?> getMinionTask(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.MINION_TASKS.get(), id);
    }

    public static IEntityAction getEntityAction(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.ENTITY_ACTIONS.get(), id);
    }

    public static Task getTask(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.TASKS.get(), id);
    }

    public static IRefinement getRefinement(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.REFINEMENTS.get(), id);
    }

    public static IRefinementSet getRefinementSet(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.REFINEMENT_SETS.get(), id);
    }

    public static IOil getOil(@NotNull ResourceLocation id) {
        return RegUtil.get(ModRegistries.OILS.get(), id);
    }

    public static <T> T get(@NotNull Supplier<IForgeRegistry<T>> registrySupplier, @NotNull ResourceLocation id) {
        return (T)registrySupplier.get().getValue(id);
    }

    public static <T> T get(@NotNull IForgeRegistry<T> registry, @NotNull ResourceLocation id) {
        return (T)registry.getValue(id);
    }

    public static <T> boolean has(@NotNull Supplier<IForgeRegistry<T>> registrySupplier, @NotNull ResourceLocation id) {
        return registrySupplier.get().containsKey(id);
    }

    public static <T> boolean has(@NotNull IForgeRegistry<T> registry, @NotNull ResourceLocation id) {
        return registry.containsKey(id);
    }

    @NotNull
    public static <T> Collection<T> values(@NotNull Supplier<IForgeRegistry<T>> registrySupplier) {
        return registrySupplier.get().getValues();
    }

    @NotNull
    public static <T> Collection<T> values(@NotNull IForgeRegistry<T> registry) {
        return registry.getValues();
    }

    @NotNull
    public static <T> Collection<ResourceLocation> keys(@NotNull Supplier<IForgeRegistry<T>> registry) {
        return registry.get().getKeys();
    }
}

