/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.templatesystem;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class RandomBlockStateRule
extends ProcessorRule {
    public static final Codec<Pair<BlockState, Optional<CompoundTag>>> PAIR_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("state").forGetter(entry -> (BlockState)entry.getLeft()), (App)CompoundTag.f_128325_.optionalFieldOf("output_nbt").forGetter(entry -> (Optional)entry.getValue())).apply((Applicative)instance, ImmutablePair::new));
    public static final Codec<RandomBlockStateRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.f_74307_.fieldOf("input_predicate").forGetter(getter -> getter.f_74216_), (App)RuleTest.f_74307_.fieldOf("location_predicate").forGetter(entry -> entry.f_74217_), (App)PAIR_CODEC.fieldOf("default_state").forGetter(entry -> Pair.of((Object)entry.f_74219_, Optional.ofNullable(entry.f_74220_))), (App)PAIR_CODEC.listOf().fieldOf("states").forGetter(entry -> Lists.newArrayList(entry.states))).apply((Applicative)instance, RandomBlockStateRule::new));
    private static final Random RNG = new Random();
    private final List<Pair<BlockState, Optional<CompoundTag>>> states;

    public RandomBlockStateRule(@NotNull RuleTest inputPredicate, @NotNull RuleTest locationPredicate, BlockState defaultState, @NotNull List<BlockState> outputStates) {
        this(inputPredicate, locationPredicate, (Pair<BlockState, Optional<CompoundTag>>)Pair.of((Object)defaultState, Optional.empty()), outputStates.stream().map(state -> Pair.of((Object)state, Optional.empty())).collect(Collectors.toList()));
    }

    public RandomBlockStateRule(@NotNull RuleTest inputPredicate, @NotNull RuleTest locationPredicate, @NotNull Pair<BlockState, Optional<CompoundTag>> defaultState, List<Pair<BlockState, Optional<CompoundTag>>> states) {
        super(inputPredicate, locationPredicate, (PosRuleTest)PosAlwaysTrueTest.f_74188_, (BlockState)defaultState.getLeft(), (Optional)defaultState.getRight());
        this.states = states;
    }

    public Pair<BlockState, Optional<CompoundTag>> getOutput() {
        if (!this.states.isEmpty()) {
            int type = RNG.nextInt(this.states.size());
            return this.states.get(type);
        }
        return Pair.of((Object)this.f_74219_, Optional.ofNullable(this.f_74220_));
    }
}

