/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.RefinementItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefinementSetFunction
extends LootItemConditionalFunction {
    @Nullable
    public final IFaction<?> faction;

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder(IFaction<?> faction) {
        return RefinementSetFunction.m_80683_(conditions -> new RefinementSetFunction((LootItemCondition[])conditions, faction));
    }

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder() {
        return RefinementSetFunction.m_80683_(conditions -> new RefinementSetFunction((LootItemCondition[])conditions, null));
    }

    public RefinementSetFunction(@NotNull @NotNull LootItemCondition @NotNull [] conditionsIn, @Nullable IFaction<?> faction) {
        super(conditionsIn);
        this.faction = faction;
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLoot.ADD_REFINEMENT_SET.get();
    }

    @NotNull
    protected ItemStack m_7372_(@NotNull ItemStack stack, @NotNull LootContext context) {
        IRefinementSet set;
        if (stack.m_41720_() instanceof IRefinementItem && (set = RefinementItem.getRandomRefinementForItem(this.faction, (IRefinementItem)stack.m_41720_())) != null) {
            ((IRefinementItem)stack.m_41720_()).applyRefinementSet(stack, set);
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RefinementSetFunction> {
        @NotNull
        public RefinementSetFunction deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context, @NotNull LootItemCondition[] conditionsIn) {
            IFaction<?> faction = null;
            if (json.has("faction")) {
                String string = json.get("faction").getAsString();
                faction = VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(json.get("faction").getAsString()));
                if (faction == null) {
                    throw new IllegalStateException("Faction " + string + " does not exist");
                }
            }
            return new RefinementSetFunction(conditionsIn, faction);
        }

        public void serialize(@NotNull JsonObject json, @NotNull RefinementSetFunction function, @NotNull JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            if (function.faction != null) {
                json.addProperty("faction", function.faction.getID().toString());
            }
        }
    }
}

