/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.types.builtin;

import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.types.IBountyObjective;
import io.ejekta.bountiful.bounty.types.Progress;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeCriteria;", "Lio/ejekta/bountiful/bounty/types/IBountyObjective;", "()V", "id", "Lnet/minecraft/util/Identifier;", "getId", "()Lnet/minecraft/util/Identifier;", "getProgress", "Lio/ejekta/bountiful/bounty/types/Progress;", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "textBoard", "", "Lnet/minecraft/text/Text;", "textSummary", "Lnet/minecraft/text/MutableText;", "isObj", "", "tryFinishObjective", "verifyValidity", "Bountiful"})
public final class BountyTypeCriteria
implements IBountyObjective {
    @NotNull
    private final ResourceLocation id = new ResourceLocation("criteria");

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @Nullable
    public MutableComponent verifyValidity(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return null;
    }

    @Override
    @NotNull
    public MutableComponent textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        MutableComponent textSum = entry.getName() != null ? Component.m_237113_((String)entry.getName()) : entry.getTranslation();
        Intrinsics.checkNotNullExpressionValue((Object)textSum, (String)"textSum");
        MutableComponent mutableComponent = this.colored((Component)textSum, progress.getColor()).m_7220_((Component)this.colored((Component)progress.getNeededText(), ChatFormatting.WHITE));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"textSum.colored(progress\u2026olored(Formatting.WHITE))");
        return mutableComponent;
    }

    @Override
    @NotNull
    public List<Component> textBoard(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return CollectionsKt.listOf((Object)(entry.getName() != null ? Component.m_237113_((String)entry.getName()) : entry.getTranslation()));
    }

    @Override
    @NotNull
    public Progress getProgress(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new Progress(entry.getCurrent(), entry.getAmount(), 0, 4, null);
    }

    @Override
    public boolean tryFinishObjective(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return entry.getCurrent() >= entry.getAmount();
    }
}

