/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.types.builtin;

import io.ejekta.bountiful.bounty.BountyData;
import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.BountyInfo;
import io.ejekta.bountiful.bounty.types.IBountyObjective;
import io.ejekta.bountiful.bounty.types.Progress;
import io.ejekta.bountiful.util.ExtMiscKt;
import io.ejekta.kambrik.ext.ExtRegIdKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity;", "Lio/ejekta/bountiful/bounty/types/IBountyObjective;", "()V", "id", "Lnet/minecraft/util/Identifier;", "getId", "()Lnet/minecraft/util/Identifier;", "incrementEntityBounties", "", "playerEntity", "Lnet/minecraft/server/network/ServerPlayerEntity;", "killedEntity", "Lnet/minecraft/entity/LivingEntity;", "textBoard", "", "Lnet/minecraft/text/Text;", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "textSummary", "Lnet/minecraft/text/MutableText;", "isObj", "", "verifyValidity", "Companion", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nBountyTypeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BountyTypeEntity.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n766#2:77\n857#2,2:78\n*S KotlinDebug\n*F\n+ 1 BountyTypeEntity.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity\n*L\n52#1:77\n52#1:78,2\n*E\n"})
public final class BountyTypeEntity
implements IBountyObjective {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation id = new ResourceLocation("entity");

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @Nullable
    public MutableComponent verifyValidity(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ResourceLocation id = ExtRegIdKt.getIdentifier(Companion.getEntityType(entry));
        if (!Intrinsics.areEqual((Object)id, (Object)new ResourceLocation(entry.getContent()))) {
            return Component.m_237113_((String)("* '" + entry.getContent() + "' is not a valid entity!"));
        }
        return null;
    }

    @Override
    @NotNull
    public MutableComponent textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        boolean bl = isObj;
        if (!bl) {
            if (!bl) {
                throw new IllegalStateException(("Cannot have an entity (" + entry.getContent() + ") as a reward.").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        MutableComponent mutableComponent = Component.m_237113_((String)"Kill ").m_7220_((Component)Companion.getEntityType(entry).m_20676_().m_6881_()).m_130940_(progress.getColor()).m_7220_((Component)this.colored((Component)progress.getNeededText(), ChatFormatting.WHITE));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(\"Kill \").append(\u2026ting.WHITE)\n            )");
        return mutableComponent;
    }

    @Override
    @NotNull
    public List<Component> textBoard(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return CollectionsKt.listOf((Object)Companion.getEntityType(entry).m_20676_());
    }

    public final void incrementEntityBounties(@NotNull ServerPlayer playerEntity, @NotNull LivingEntity killedEntity) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)killedEntity, (String)"killedEntity");
        ExtMiscKt.iterateBountyStacks(playerEntity, (Function1<? super ItemStack, Unit>)((Function1)arg_0 -> BountyTypeEntity.incrementEntityBounties$lambda$1(killedEntity, playerEntity, this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit incrementEntityBounties$lambda$1(LivingEntity $killedEntity, ServerPlayer $playerEntity, BountyTypeEntity this$0, ItemStack $receiver) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$killedEntity, (String)"$killedEntity");
        Intrinsics.checkNotNullParameter((Object)$playerEntity, (String)"$playerEntity");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        BountyInfo info = (BountyInfo)BountyInfo.Companion.get($receiver);
        BountyData data = (BountyData)BountyData.Companion.get($receiver);
        Iterable $this$filter$iv = data.getObjectives();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BountyDataEntry it = (BountyDataEntry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getLogicId(), (Object)this$0.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entityObjs = (List)destination$iv$iv;
        if (!((Collection)entityObjs).isEmpty()) {
            boolean changes = false;
            for (BountyDataEntry obj : entityObjs) {
                String string = obj.getContent();
                EntityType entityType = $killedEntity.m_6095_();
                Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"killedEntity.type");
                if (!Intrinsics.areEqual((Object)string, (Object)ExtRegIdKt.getIdentifier((EntityType)entityType).toString())) continue;
                obj.setCurrent(obj.getCurrent() + 1);
                changes = true;
            }
            if (changes) {
                BountyData.Companion.set($receiver, data);
                data.checkForCompletionAndAlert((Player)$playerEntity, $receiver);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeEntity$Companion;", "", "()V", "getEntityType", "Lnet/minecraft/entity/EntityType;", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "Bountiful"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityType<?> getEntityType(@NotNull BountyDataEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Object object = BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(entry.getContent()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ENTITY_TYPE.get(Identifier(entry.content))");
            return (EntityType)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

