/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.types.builtin;

import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.types.IBountyExchangeable;
import io.ejekta.bountiful.bounty.types.Progress;
import io.ejekta.kambrik.ext.ExtInventoryKt;
import io.ejekta.kambrik.ext.ExtRegIdKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeItem;", "Lio/ejekta/bountiful/bounty/types/IBountyExchangeable;", "()V", "id", "Lnet/minecraft/util/Identifier;", "getId", "()Lnet/minecraft/util/Identifier;", "getCurrentStacks", "", "Lnet/minecraft/item/ItemStack;", "", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "getNewCurrent", "getProgress", "Lio/ejekta/bountiful/bounty/types/Progress;", "giveReward", "", "textBoard", "", "Lnet/minecraft/text/Text;", "textSummary", "Lnet/minecraft/text/MutableText;", "isObj", "tryFinishObjective", "verifyValidity", "Companion", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nBountyTypeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BountyTypeItem.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeItem\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n215#2,2:108\n1549#3:110\n1620#3,3:111\n*S KotlinDebug\n*F\n+ 1 BountyTypeItem.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeItem\n*L\n62#1:108,2\n72#1:110\n72#1:111,3\n*E\n"})
public final class BountyTypeItem
implements IBountyExchangeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation id = new ResourceLocation("item");

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @Nullable
    public MutableComponent verifyValidity(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ResourceLocation id = ExtRegIdKt.getIdentifier((Item)Companion.getItem(entry));
        if (!Intrinsics.areEqual((Object)id, (Object)new ResourceLocation(entry.getContent()))) {
            return Component.m_237113_((String)("* '" + entry.getContent() + "' is not a valid item!"));
        }
        return null;
    }

    private final Map<ItemStack, Integer> getCurrentStacks(BountyDataEntry entry, Player player) {
        NonNullList nonNullList = player.m_150109_().f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"player.inventory.main");
        return ExtInventoryKt.collect((List)((List)nonNullList), (int)entry.getAmount(), arg_0 -> BountyTypeItem.getCurrentStacks$lambda$0(entry, arg_0));
    }

    @Override
    @NotNull
    public MutableComponent textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull Player player) {
        MutableComponent mutableComponent;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        MutableComponent itemName = Companion.getItemName(entry);
        boolean bl = isObj;
        if (bl) {
            MutableComponent mutableComponent2 = itemName.m_130940_(progress.getColor()).m_7220_((Component)this.colored((Component)progress.getNeededText(), ChatFormatting.WHITE));
            mutableComponent = mutableComponent2;
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"itemName.formatted(progr\u2026olored(Formatting.WHITE))");
        } else if (!bl) {
            MutableComponent mutableComponent3 = progress.getGivingText().m_7220_((Component)this.colored((Component)itemName, entry.getRarity().getColor()));
            mutableComponent = mutableComponent3;
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"progress.givingText.appe\u2026ored(entry.rarity.color))");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mutableComponent;
    }

    @Override
    @NotNull
    public List<Component> textBoard(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List list = Companion.getItemStack(entry).m_41651_(player, (TooltipFlag)TooltipFlag.f_256752_);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItemStack(entry).getT\u2026er, TooltipContext.BASIC)");
        return list;
    }

    @Override
    @NotNull
    public Progress getProgress(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new Progress(CollectionsKt.sumOfInt((Iterable)this.getCurrentStacks(entry, player).values()), entry.getAmount(), 0, 4, null);
    }

    @Override
    public int getNewCurrent(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return CollectionsKt.sumOfInt((Iterable)this.getCurrentStacks(entry, player).values());
    }

    @Override
    public boolean tryFinishObjective(@NotNull BountyDataEntry entry, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<ItemStack, Integer> currStacks = this.getCurrentStacks(entry, player);
        if (CollectionsKt.sumOfInt((Iterable)currStacks.values()) >= entry.getAmount()) {
            Map<ItemStack, Integer> $this$forEach$iv = currStacks;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ItemStack, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ItemStack, Integer> element$iv;
                Map.Entry<ItemStack, Integer> entry2 = element$iv = iterator.next();
                boolean bl = false;
                ItemStack stack = entry2.getKey();
                int toShrink = ((Number)entry2.getValue()).intValue();
                stack.m_41774_(toShrink);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean giveReward(@NotNull BountyDataEntry entry, @NotNull Player player) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Item item = Companion.getItem(entry);
        Iterable $this$map$iv = CollectionsKt.chunked((Iterable)((Iterable)RangesKt.until((int)0, (int)entry.getAmount())), (int)item.m_41459_());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.size());
        }
        List toGive = (List)destination$iv$iv;
        Iterator iterator = toGive.iterator();
        while (iterator.hasNext()) {
            ItemEntity itemEntity;
            int amtToGive = ((Number)iterator.next()).intValue();
            Collection $this$giveReward_u24lambda_u243 = destination$iv$iv = new ItemStack((ItemLike)item, amtToGive);
            boolean bl = false;
            $this$giveReward_u24lambda_u243.m_41751_(entry.getNbt());
            Collection stack = destination$iv$iv;
            if (player.m_36356_((ItemStack)stack)) continue;
            ItemEntity $this$giveReward_u24lambda_u244 = itemEntity = new ItemEntity(player.f_19853_, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (ItemStack)stack);
            boolean bl2 = false;
            $this$giveReward_u24lambda_u244.m_32010_(0);
            ItemEntity stackEntity = itemEntity;
            player.f_19853_.m_7967_((Entity)stackEntity);
        }
        return true;
    }

    private static final boolean getCurrentStacks$lambda$0(BountyDataEntry $entry, ItemStack $receiver) {
        Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)ExtRegIdKt.getIdentifier((ItemStack)$receiver).toString(), (Object)$entry.getContent());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lio/ejekta/bountiful/bounty/types/builtin/BountyTypeItem$Companion;", "", "()V", "getItem", "Lnet/minecraft/item/Item;", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "getItemName", "Lnet/minecraft/text/MutableText;", "getItemStack", "Lnet/minecraft/item/ItemStack;", "Bountiful"})
    @SourceDebugExtension(value={"SMAP\nBountyTypeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BountyTypeItem.kt\nio/ejekta/bountiful/bounty/types/builtin/BountyTypeItem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item getItem(@NotNull BountyDataEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Object object = BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(entry.getContent()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ITEM.get(Identifier(entry.content))");
            return (Item)object;
        }

        @NotNull
        public final ItemStack getItemStack(@NotNull BountyDataEntry entry) {
            ItemStack itemStack;
            block0: {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                Item item = this.getItem(entry);
                ItemStack $this$getItemStack_u24lambda_u241 = itemStack = new ItemStack((ItemLike)item);
                boolean bl = false;
                CompoundTag compoundTag = entry.getNbt();
                if (compoundTag == null) break block0;
                CompoundTag it = compoundTag;
                boolean bl2 = false;
                $this$getItemStack_u24lambda_u241.m_41751_(it);
            }
            return itemStack;
        }

        @NotNull
        public final MutableComponent getItemName(@NotNull BountyDataEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            MutableComponent mutableComponent = this.getItem(entry).m_41466_().m_6881_();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getItem(entry).name.copy()");
            return mutableComponent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

