/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bridge;

import io.ejekta.bountiful.Bountiful;
import io.ejekta.bountiful.bounty.BountyData;
import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.BountyInfo;
import io.ejekta.bountiful.bounty.DecreeData;
import io.ejekta.bountiful.bounty.types.BountyTypeRegistry;
import io.ejekta.bountiful.bounty.types.builtin.BountyTypeEntity;
import io.ejekta.bountiful.content.BountifulContent;
import io.ejekta.bountiful.content.messages.ClipboardCopy;
import io.ejekta.bountiful.content.messages.OnBountyComplete;
import io.ejekta.bountiful.content.messages.SelectBounty;
import io.ejekta.bountiful.content.messages.UpdateBountyCriteriaObjective;
import io.ejekta.bountiful.util.ExtMiscKt;
import io.ejekta.kambrik.Kambrik;
import io.ejekta.kambrik.criterion.KambrikCriterionApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lio/ejekta/bountiful/bridge/BountifulSharedApi;", "", "handleEntityKills", "", "world", "Lnet/minecraft/server/world/ServerWorld;", "entity", "Lnet/minecraft/entity/Entity;", "killedEntity", "Lnet/minecraft/entity/LivingEntity;", "isModLoaded", "", "id", "", "registerClientMessages", "registerCriterionStuff", "registerItemDynamicTextures", "registerServerMessages", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nBountifulSharedApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BountifulSharedApi.kt\nio/ejekta/bountiful/bridge/BountifulSharedApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,121:1\n1855#2,2:122\n766#2:124\n857#2,2:125\n1#3:127\n27#4,3:128\n27#4,4:131\n30#4:135\n*S KotlinDebug\n*F\n+ 1 BountifulSharedApi.kt\nio/ejekta/bountiful/bridge/BountifulSharedApi\n*L\n74#1:122,2\n87#1:124\n87#1:125,2\n95#1:128,3\n97#1:131,4\n95#1:135\n*E\n"})
public interface BountifulSharedApi {
    public boolean isModLoaded(@NotNull String var1);

    default public void registerItemDynamicTextures() {
        ItemProperties.m_174570_((Item)BountifulContent.INSTANCE.getBOUNTY_ITEM(), (ResourceLocation)Bountiful.Companion.id("rarity"), BountifulSharedApi::registerItemDynamicTextures$lambda$0);
        ItemProperties.m_174570_((Item)BountifulContent.INSTANCE.getDECREE_ITEM(), (ResourceLocation)Bountiful.Companion.id("status"), BountifulSharedApi::registerItemDynamicTextures$lambda$1);
    }

    default public void registerServerMessages() {
        Kambrik.INSTANCE.getMessage().registerServerMessage(SelectBounty.Companion.serializer(), Reflection.getOrCreateKotlinClass(SelectBounty.class), Bountiful.Companion.id("select_bounty"));
    }

    default public void registerClientMessages() {
        Kambrik.INSTANCE.getMessage().registerClientMessage(ClipboardCopy.Companion.serializer(), Reflection.getOrCreateKotlinClass(ClipboardCopy.class), Bountiful.Companion.id("clipboard_copy"));
        Kambrik.INSTANCE.getMessage().registerClientMessage(OnBountyComplete.Companion.serializer(), Reflection.getOrCreateKotlinClass(OnBountyComplete.class), Bountiful.Companion.id("play_sound_on_client"));
        Kambrik.INSTANCE.getMessage().registerClientMessage(UpdateBountyCriteriaObjective.Companion.serializer(), Reflection.getOrCreateKotlinClass(UpdateBountyCriteriaObjective.class), Bountiful.Companion.id("update_bounty_criteria"));
    }

    default public void handleEntityKills(@NotNull ServerLevel world, @NotNull Entity entity, @NotNull LivingEntity killedEntity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)killedEntity, (String)"killedEntity");
        if (entity instanceof ServerPlayer) {
            List list = world.m_8795_(arg_0 -> BountifulSharedApi.handleEntityKills$lambda$3(arg_0 -> BountifulSharedApi.handleEntityKills$lambda$2(entity, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"world.getPlayers { it.distanceTo(entity) < 12f }");
            Collection collection = list;
            List list2 = world.m_8795_(arg_0 -> BountifulSharedApi.handleEntityKills$lambda$5(arg_0 -> BountifulSharedApi.handleEntityKills$lambda$4(killedEntity, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"world.getPlayers { it.di\u2026eTo(killedEntity) < 12f }");
            List playersInAction = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list2), (Object)entity);
            Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)playersInAction);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer it = (ServerPlayer)element$iv;
                boolean bl = false;
                BountyTypeEntity bountyTypeEntity = BountyTypeRegistry.INSTANCE.getENTITY();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                bountyTypeEntity.incrementEntityBounties(it, killedEntity);
            }
        }
    }

    default public void registerCriterionStuff() {
        Kambrik.INSTANCE.getCriterion().subscribe(BountifulSharedApi::registerCriterionStuff$lambda$12);
    }

    private static float registerItemDynamicTextures$lambda$0(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int seed) {
        Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
        return (float)((BountyInfo)BountyInfo.Companion.get(stack)).getRarity().ordinal() / 10.0f;
    }

    private static float registerItemDynamicTextures$lambda$1(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int seed) {
        Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
        DecreeData data = (DecreeData)DecreeData.Companion.get(stack);
        return !((Collection)data.getIds()).isEmpty() ? 1.0f : 0.0f;
    }

    private static boolean handleEntityKills$lambda$2(Entity $entity, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        return it.m_20270_($entity) < 12.0f;
    }

    private static boolean handleEntityKills$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static boolean handleEntityKills$lambda$4(LivingEntity $killedEntity, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$killedEntity, (String)"$killedEntity");
        return it.m_20270_((Entity)$killedEntity) < 12.0f;
    }

    private static boolean handleEntityKills$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static Unit registerCriterionStuff$lambda$12$lambda$11(SimpleCriterionTrigger $criterion, Predicate $predicate, ServerPlayer $player, ItemStack $receiver) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$criterion, (String)"$criterion");
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        BountyData data = (BountyData)BountyData.Companion.get($receiver);
        Iterable $this$filter$iv = data.getObjectives();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BountyDataEntry it = (BountyDataEntry)element$iv$iv;
            boolean bl = false;
            if (!(it.getCritConditions() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable it = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? $this$filter$iv : null;
        if (iterable2 == null) {
            iterable2 = CollectionsKt.emptyList();
        }
        Iterable triggerObjs = iterable2;
        for (BountyDataEntry obj : triggerObjs) {
            boolean result;
            void $this$registerCriterionStuff_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
            JsonObjectBuilder builder$iv;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
            KambrikCriterionApi kambrikCriterionApi = Kambrik.INSTANCE.getCriterion();
            SimpleCriterionTrigger simpleCriterionTrigger = $criterion;
            KambrikCriterionApi kambrikCriterionApi2 = Kambrik.INSTANCE.getCriterion();
            boolean bl2 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$registerCriterionStuff_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, (String)"trigger", (String)obj.getContent());
            void v1 = $this$registerCriterionStuff_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
            String string = "conditions";
            JsonObject jsonObject = obj.getCritConditions();
            if (jsonObject == null) {
                JsonObjectBuilder builder$iv2;
                boolean $i$f$buildJsonObject2 = false;
                JsonObjectBuilder jsonObjectBuilder2 = builder$iv2 = new JsonObjectBuilder();
                String string2 = string;
                void var18_26 = v1;
                boolean bl3 = false;
                Unit unit = Unit.INSTANCE;
                v1 = var18_26;
                string = string2;
                jsonObject = builder$iv2.build();
            }
            v1.put(string, (JsonElement)jsonObject);
            Unit unit = Unit.INSTANCE;
            AbstractCriterionTriggerInstance abstractCriterionTriggerInstance = kambrikCriterionApi.createCriterionConditionsFromJson(builder$iv.build());
            if (abstractCriterionTriggerInstance == null || !(result = kambrikCriterionApi2.testAgainst(simpleCriterionTrigger, abstractCriterionTriggerInstance, $predicate))) continue;
            obj.setCurrent(obj.getCurrent() + 1);
            new UpdateBountyCriteriaObjective($player.m_150109_().m_36043_($receiver), data.getObjectives().indexOf(obj)).sendToClient($player);
            BountyData.Companion.set($receiver, data);
        }
        data.checkForCompletionAndAlert((Player)$player, $receiver);
        return Unit.INSTANCE;
    }

    private static void registerCriterionStuff$lambda$12(ServerPlayer player, SimpleCriterionTrigger criterion, Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)criterion, (String)"criterion");
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(criterion instanceof PlayerTrigger) && !(criterion instanceof EnterBlockTrigger)) {
            ExtMiscKt.iterateBountyStacks(player, (Function1<? super ItemStack, Unit>)((Function1)arg_0 -> BountifulSharedApi.registerCriterionStuff$lambda$12$lambda$11(criterion, predicate, player, arg_0)));
        }
    }
}

