/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.api.fluids;

import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EffectFluid {
    public Fluid fluid;
    public int effectID;
    public int amountRequired;

    public EffectFluid(FluidStack fluidStack, int amountRequired) {
        this(fluidStack.getFluid(), amountRequired);
    }

    public EffectFluid(Fluid fluid, int amountRequired) {
        this.fluid = fluid;
        this.effectID = 0;
        this.amountRequired = amountRequired;
        if (fluid != null) {
            EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public EffectFluid(String modid, String fluidName, int amountRequired) {
        Fluid fluid;
        this.fluid = fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(modid, fluidName));
        this.effectID = 0;
        this.amountRequired = amountRequired;
        if (fluid != null) {
            EffectFluidRegistry.registerFluidEffect(this);
        }
    }

    public void setEffectID(int id) {
        this.effectID = id;
    }

    public int getEffectID() {
        return this.effectID;
    }

    public abstract void affectDrinker(FluidStack var1, Level var2, Entity var3);

    public abstract boolean canExecuteEffect(FluidStack var1, Level var2, Entity var3);
}

