/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.LegacyUpgradeRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class BackpackUpgradeRecipe
extends LegacyUpgradeRecipe {
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public BackpackUpgradeRecipe(ResourceLocation id, Ingredient base, Ingredient addition, ItemStack result) {
        super(id, base, addition, result);
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack itemstack = this.m_8043_(registryAccess).m_41777_();
        CompoundTag compoundtag = container.m_8020_(0).m_41783_();
        if (compoundtag != null && (compoundtag = compoundtag.m_6426_()).m_128441_("Tier")) {
            Tiers.Tier tier = Tiers.of(compoundtag.m_128461_("Tier"));
            if (this.addition.test(Tiers.of(compoundtag.m_128461_("Tier")).getTierUpgradeIngredient().m_7968_())) {
                compoundtag.m_128359_("Tier", tier.getNextTier().getName());
                itemstack.m_41751_(compoundtag.m_6426_());
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(Container p_267029_, Level p_267244_) {
        return TravelersBackpackConfig.enableTierUpgrades && super.m_5818_(p_267029_, p_267244_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        public BackpackUpgradeRecipe fromJson(ResourceLocation p_267011_, JsonObject p_267297_) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_267297_, (String)"base"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_267297_, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_267297_, (String)"result"));
            return new BackpackUpgradeRecipe(p_267011_, ingredient, ingredient1, itemstack);
        }

        public BackpackUpgradeRecipe fromNetwork(ResourceLocation p_266671_, FriendlyByteBuf p_266826_) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)p_266826_);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)p_266826_);
            ItemStack itemstack = p_266826_.m_130267_();
            return new BackpackUpgradeRecipe(p_266671_, ingredient, ingredient1, itemstack);
        }

        public void toNetwork(FriendlyByteBuf p_266918_, BackpackUpgradeRecipe p_266728_) {
            p_266728_.base.m_43923_(p_266918_);
            p_266728_.addition.m_43923_(p_266918_);
            p_266918_.m_130055_(p_266728_.result);
        }
    }
}

