/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.fluids;

import com.tiviacz.travelersbackpack.util.FluidUtils;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class PotionFluidType
extends FluidType {
    public static final ResourceLocation POTION_STILL_RL = new ResourceLocation("travelersbackpack", "block/potion_still");
    public static final ResourceLocation POTION_FLOW_RL = new ResourceLocation("travelersbackpack", "block/potion_flow");

    public PotionFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public int getTintColor(FluidStack stack) {
                return PotionUtils.m_43575_((ItemStack)FluidUtils.getItemStackFromFluidStack(stack)) | 0xFF000000;
            }

            public int getTintColor() {
                return 13458603;
            }

            public ResourceLocation getStillTexture() {
                return POTION_STILL_RL;
            }

            public ResourceLocation getFlowingTexture() {
                return POTION_FLOW_RL;
            }
        });
    }
}

