/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class SlotManager {
    protected final ITravelersBackpackContainer container;
    protected List<Integer> unsortableSlots = new ArrayList<Integer>();
    protected List<Pair<Integer, ItemStack>> memorySlots = new ArrayList<Pair<Integer, ItemStack>>();
    protected boolean isUnsortableActive = false;
    protected boolean isMemoryActive = false;
    private final String UNSORTABLE_SLOTS = "UnsortableSlots";
    private final String MEMORY_SLOTS = "MemorySlots";
    public static final byte UNSORTABLE = 0;
    public static final byte MEMORY = 1;

    public SlotManager(ITravelersBackpackContainer container) {
        this.container = container;
    }

    public List<Integer> getUnsortableSlots() {
        return this.unsortableSlots;
    }

    public List<Pair<Integer, ItemStack>> getMemorySlots() {
        return this.memorySlots;
    }

    public boolean isSlot(byte type, int slot) {
        if (type == 0) {
            return this.unsortableSlots.contains(slot);
        }
        if (type == 1) {
            for (Pair<Integer, ItemStack> pair : this.memorySlots) {
                if ((Integer)pair.getFirst() != slot) continue;
                return true;
            }
        }
        return false;
    }

    public void setUnsortableSlots(int[] slots, boolean isFinal) {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = Arrays.stream(slots).boxed().collect(Collectors.toList());
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlots(int[] slots, ItemStack[] stacks, boolean isFinal) {
        if (this.isSelectorActive((byte)1)) {
            ArrayList<Pair<Integer, ItemStack>> pairs = new ArrayList<Pair<Integer, ItemStack>>();
            for (int i = 0; i < slots.length; ++i) {
                pairs.add((Pair<Integer, ItemStack>)Pair.of((Object)slots[i], (Object)stacks[i]));
            }
            pairs.sort(Comparator.comparing(pair -> ((Integer)pair.getFirst()).toString()));
            this.memorySlots = pairs;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlot(int slot, ItemStack stack) {
        if (this.isSelectorActive((byte)1) && slot <= this.container.getTier().getStorageSlots() - 7) {
            if (this.isSlot((byte)1, slot)) {
                this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot);
            } else {
                this.memorySlots.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
            }
        }
    }

    public void setUnsortableSlot(int slot) {
        if (this.isSelectorActive((byte)0) && slot <= this.container.getTier().getStorageSlots() - 7) {
            if (this.isSlot((byte)0, slot)) {
                this.unsortableSlots.remove((Object)slot);
            } else {
                this.unsortableSlots.add(slot);
            }
        }
    }

    public void clearUnsortables() {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = new ArrayList<Integer>();
        }
    }

    public void clearMemory() {
        if (this.isSelectorActive((byte)1)) {
            this.memorySlots = new ArrayList<Pair<Integer, ItemStack>>();
        }
    }

    public void setChanged() {
        if (this.container.getScreenID() != 3) {
            this.container.setDataChanged(8);
        } else {
            this.container.setDataChanged();
        }
    }

    public boolean isSelectorActive(byte type) {
        return switch (type) {
            case 0 -> this.isUnsortableActive;
            case 1 -> this.isMemoryActive;
            default -> false;
        };
    }

    public void setSelectorActive(byte type, boolean bool) {
        switch (type) {
            case 0: {
                this.isUnsortableActive = bool;
                break;
            }
            case 1: {
                this.isMemoryActive = bool;
            }
        }
    }

    public void saveUnsortableSlots(CompoundTag compound) {
        compound.m_128385_("UnsortableSlots", this.getUnsortableSlots().stream().mapToInt(i -> i).toArray());
    }

    public void loadUnsortableSlots(CompoundTag compound) {
        this.unsortableSlots = Arrays.stream(compound.m_128465_("UnsortableSlots")).boxed().collect(Collectors.toList());
    }

    public void saveMemorySlots(CompoundTag compound) {
        ListTag memorySlotsList = new ListTag();
        for (Pair<Integer, ItemStack> pair : this.memorySlots) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", ((Integer)pair.getFirst()).intValue());
            ((ItemStack)pair.getSecond()).m_41739_(itemTag);
            memorySlotsList.add((Object)itemTag);
        }
        compound.m_128365_("MemorySlots", (Tag)memorySlotsList);
    }

    public void loadMemorySlots(CompoundTag compound) {
        ListTag tagList = compound.m_128437_("MemorySlots", 10);
        ArrayList<Pair<Integer, ItemStack>> pairs = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.m_128728_(i);
            int slot = itemTag.m_128451_("Slot");
            if (slot > this.container.getTier().getStorageSlots() - 7) continue;
            Pair pair = Pair.of((Object)slot, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
            pairs.add((Pair<Integer, ItemStack>)pair);
        }
        this.memorySlots = pairs;
    }
}

