/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.chat;

import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public final class MinecraftTextClickEvent {
    @NotNull
    private final Action action;
    @NotNull
    private final String value;

    @NotNull
    public static MinecraftTextClickEvent openUrl(@NotNull String url) {
        return new MinecraftTextClickEvent(Action.OPEN_URL, url);
    }

    @NotNull
    public static MinecraftTextClickEvent runCommand(@NotNull String command) {
        return new MinecraftTextClickEvent(Action.RUN_COMMAND, command);
    }

    @NotNull
    public static MinecraftTextClickEvent suggestCommand(@NotNull String command) {
        return new MinecraftTextClickEvent(Action.SUGGEST_COMMAND, command);
    }

    @NotNull
    public static MinecraftTextClickEvent changePage(@NotNull String page) {
        return new MinecraftTextClickEvent(Action.CHANGE_PAGE, page);
    }

    @NotNull
    public static MinecraftTextClickEvent copyToClipboard(@NotNull String text) {
        return new MinecraftTextClickEvent(Action.COPY_TO_CLIPBOARD, text);
    }

    @NotNull
    public static MinecraftTextClickEvent clickEvent(@NotNull Action action, @NotNull String value) {
        return new MinecraftTextClickEvent(action, value);
    }

    private MinecraftTextClickEvent(@NonNull Action action, @NonNull String value) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.action = action;
        this.value = value;
    }

    @NotNull
    public Action action() {
        return this.action;
    }

    @NotNull
    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinecraftTextClickEvent)) {
            return false;
        }
        MinecraftTextClickEvent other = (MinecraftTextClickEvent)o;
        Action this$action = this.action();
        Action other$action = other.action();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$value = this.value();
        String other$value = other.value();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.action();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $value = this.value();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "MinecraftTextClickEvent(action=" + (Object)((Object)this.action()) + ", value=" + this.value() + ")";
    }

    public static enum Action {
        OPEN_URL,
        OPEN_FILE,
        RUN_COMMAND,
        SUGGEST_COMMAND,
        CHANGE_PAGE,
        COPY_TO_CLIPBOARD;

    }
}

