/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.api.chat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftLiteralText;
import su.plo.lib.api.chat.MinecraftTextClickEvent;
import su.plo.lib.api.chat.MinecraftTextHoverEvent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.api.chat.MinecraftTranslatableText;

public abstract class MinecraftTextComponent {
    protected final List<MinecraftTextStyle> styles = new ArrayList<MinecraftTextStyle>();
    protected final List<MinecraftTextComponent> siblings = new ArrayList<MinecraftTextComponent>();
    @Nullable
    protected MinecraftTextClickEvent clickEvent;
    @Nullable
    protected MinecraftTextHoverEvent hoverEvent;

    public static MinecraftLiteralText literal(String text) {
        return new MinecraftLiteralText(text);
    }

    public static MinecraftTranslatableText translatable(String key, Object ... args) {
        return new MinecraftTranslatableText(key, args);
    }

    public static MinecraftTextComponent empty() {
        return new MinecraftLiteralText("");
    }

    public MinecraftTextComponent append(MinecraftTextComponent ... components) {
        Collections.addAll(this.siblings, components);
        return this;
    }

    public MinecraftTextComponent append(@NotNull Collection<MinecraftTextComponent> components) {
        this.siblings.addAll(components);
        return this;
    }

    public MinecraftTextComponent withStyle(@NotNull MinecraftTextStyle style) {
        this.styles.add(style);
        return this;
    }

    public MinecraftTextComponent withStyle(MinecraftTextStyle ... styles) {
        this.styles.addAll(Arrays.asList(styles));
        return this;
    }

    public MinecraftTextComponent clickEvent(@Nullable MinecraftTextClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    public MinecraftTextComponent hoverEvent(@Nullable MinecraftTextHoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    public MinecraftTextComponent mergeWith(@NotNull MinecraftTextComponent component) {
        return this.withStyle(component.styles().toArray(new MinecraftTextStyle[0])).append(component.siblings()).clickEvent(component.clickEvent()).hoverEvent(component.hoverEvent());
    }

    public List<MinecraftTextStyle> styles() {
        return this.styles;
    }

    public List<MinecraftTextComponent> siblings() {
        return this.siblings;
    }

    @Nullable
    public MinecraftTextClickEvent clickEvent() {
        return this.clickEvent;
    }

    @Nullable
    public MinecraftTextHoverEvent hoverEvent() {
        return this.hoverEvent;
    }
}

