/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.chat;

import java.util.List;
import lombok.NonNull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextClickEvent;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextConverter;
import su.plo.lib.api.chat.MinecraftTextHoverEvent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.api.chat.MinecraftTranslatableText;

public final class ComponentTextConverter
implements MinecraftTextConverter<Component> {
    @Override
    @NotNull
    public String convertToJson(@NotNull Component text) {
        return Component.Serializer.m_130703_((Component)text);
    }

    @Override
    public Component convertFromJson(@NotNull String json2) {
        return Component.Serializer.m_130701_((String)json2);
    }

    @Override
    public Component convert(@NotNull MinecraftTextComponent text) {
        MutableComponent component = text instanceof MinecraftTranslatableText ? this.convertTranslatable((MinecraftTranslatableText)text) : Component.m_237113_((String)text.toString());
        component = this.applyStyles(component, text.styles());
        component = this.applyClickEvent(component, text.clickEvent());
        component = this.applyHoverEvent(component, text.hoverEvent());
        for (MinecraftTextComponent sibling : text.siblings()) {
            component.m_7220_(this.convert(sibling));
        }
        return component;
    }

    private MutableComponent convertTranslatable(@NotNull MinecraftTranslatableText text) {
        Object[] args = new Object[text.getArgs().length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = text.getArgs()[i];
            args[i] = arg instanceof MinecraftTextComponent ? this.convert((MinecraftTextComponent)arg) : arg;
        }
        return Component.m_237110_((String)text.getKey(), (Object[])args);
    }

    private MutableComponent applyClickEvent(@NotNull MutableComponent component, @Nullable MinecraftTextClickEvent clickEvent) {
        if (clickEvent == null) {
            return component;
        }
        component.m_6270_(component.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.valueOf((String)clickEvent.action().name()), clickEvent.value())));
        return component;
    }

    private MutableComponent applyHoverEvent(@NotNull MutableComponent component, @Nullable MinecraftTextHoverEvent hoverEvent) {
        if (hoverEvent == null) {
            return component;
        }
        if (hoverEvent.action() == MinecraftTextHoverEvent.Action.SHOW_TEXT) {
            component.m_6270_(component.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.convert((MinecraftTextComponent)hoverEvent.value()))));
        }
        return component;
    }

    private MutableComponent applyStyles(@NonNull MutableComponent component, @NotNull List<MinecraftTextStyle> styles) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (styles.isEmpty()) {
            return component;
        }
        component.m_6270_(component.m_7383_().m_131152_((ChatFormatting[])styles.stream().map(this::convertStyle).toArray(ChatFormatting[]::new)));
        return component;
    }

    private ChatFormatting convertStyle(@NotNull MinecraftTextStyle style) {
        return ChatFormatting.valueOf((String)style.name());
    }
}

