/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.chat;

import java.util.Map;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextConverter;
import su.plo.lib.api.chat.MinecraftTranslatableText;
import su.plo.lib.api.chat.TranslatableTextConverter;
import su.plo.lib.mod.chat.ComponentTextConverter;
import su.plo.lib.mod.client.chat.ClientLanguageSupplier;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.voice.universal.wrappers.message.UTextComponent;

public final class ClientTextConverter
extends TranslatableTextConverter<Component> {
    private final MinecraftTextConverter<Component> textConverter = new ComponentTextConverter();
    private ClientLanguageSupplier languageSupplier;

    @Override
    @NotNull
    public String convertToJson(@NotNull Component text) {
        return Component.Serializer.m_130703_((Component)text);
    }

    @Override
    public Component convertFromJson(@NotNull String json2) {
        return Component.Serializer.m_130701_((String)json2);
    }

    @Override
    public Component convert(@NotNull MinecraftTextComponent text) {
        if (!(text instanceof MinecraftTranslatableText) || this.languageSupplier == null) {
            return this.textConverter.convert(text);
        }
        return this.languageSupplier.get().map(language -> {
            MinecraftTextComponent translatedText = this.translateInner((Map<String, String>)language, text);
            if (!(translatedText instanceof MinecraftTranslatableText)) {
                return this.textConverter.convert(translatedText);
            }
            MinecraftTranslatableText translatable = (MinecraftTranslatableText)translatedText;
            if (!language.containsKey(translatable.getKey())) {
                return this.textConverter.convert(translatable);
            }
            if (LanguageUtil.has(translatable.getKey())) {
                return this.textConverter.convert(translatable);
            }
            return this.textConverter.convert(this.translate((Map<String, String>)language, translatable));
        }).orElseGet(() -> this.textConverter.convert(text));
    }

    public UTextComponent convertToUniversal(@NotNull MinecraftTextComponent text) {
        return new UTextComponent(this.convert(text));
    }

    public void setLanguageSupplier(ClientLanguageSupplier languageSupplier) {
        this.languageSupplier = languageSupplier;
    }
}

