/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.ModVoiceClient;
import su.plo.voice.client.event.key.KeyPressedEvent;
import su.plo.voice.universal.UKeyboard;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UMinecraft;
import su.plo.voice.universal.UMouse;
import su.plo.voice.universal.UResolution;
import su.plo.voice.universal.UScreen;

public final class ScreenWrapper
extends UScreen {
    private final GuiScreen screen;
    private boolean ignoreFirstMove = true;
    private double lastDraggedMouseX;
    private double lastDraggedMouseY;

    public static void openScreen(@Nullable GuiScreen screen) {
        ScreenWrapper wrapped;
        if (screen == null) {
            UMinecraft.getMinecraft().execute(() -> UScreen.displayScreen(null));
            return;
        }
        wrapped.screen.screen = wrapped = new ScreenWrapper(screen);
        UMinecraft.getMinecraft().execute(() -> UScreen.displayScreen(wrapped));
    }

    public static Optional<ScreenWrapper> getCurrentWrappedScreen() {
        Screen screen = UScreen.getCurrentScreen();
        if (screen instanceof ScreenWrapper) {
            return Optional.of((ScreenWrapper)screen);
        }
        return Optional.empty();
    }

    private ScreenWrapper(@NotNull GuiScreen screen) {
        this.screen = screen;
    }

    @Override
    @NotNull
    public Component m_96636_() {
        return RenderUtil.getTextConverter().convert(this.screen.getTitle());
    }

    @Override
    public void onTick() {
        this.screen.tick();
    }

    @Override
    public void initScreen(int width, int height) {
        this.screen.init();
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        ModVoiceClient.INSTANCE.getEventBus().register(ModVoiceClient.INSTANCE, (Object)this);
    }

    @Override
    public void onScreenClose() {
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        this.screen.removed();
    }

    @Override
    public void onDrawScreen(@NotNull UMatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.screen.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.screen.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, int button) {
        this.screen.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void onMouseDragged(double mouseX, double mouseY, int button, long timeSinceLastClick) {
        if (this.ignoreFirstMove) {
            this.lastDraggedMouseX = mouseX;
            this.lastDraggedMouseY = mouseY;
            this.ignoreFirstMove = false;
        }
        double deltaX = (mouseX - this.lastDraggedMouseX) * (double)UResolution.getScaledWidth() / (double)UResolution.getWindowWidth() * UResolution.getScaleFactor();
        double deltaY = (mouseY - this.lastDraggedMouseY) * (double)UResolution.getScaledHeight() / (double)UResolution.getWindowHeight() * UResolution.getScaleFactor();
        this.lastDraggedMouseX = mouseX;
        this.lastDraggedMouseY = mouseY;
        this.screen.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public void onMouseScrolled(double delta) {
        this.screen.mouseScrolled(UMouse.Scaled.getX(), UMouse.Scaled.getY(), delta);
    }

    @Override
    public void onKeyPressed(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        boolean shiftKeyDown;
        if (keyCode == 0) {
            this.screen.charTyped(typedChar, modifiers);
            return;
        }
        if (this.screen.keyPressed(keyCode, modifiers)) {
            return;
        }
        if (keyCode == UKeyboard.KEY_TAB && !this.screen.changeFocus(shiftKeyDown = UKeyboard.isShiftKeyDown())) {
            this.screen.changeFocus(shiftKeyDown);
        }
    }

    @Override
    public void onKeyReleased(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.screen.keyReleased(keyCode, typedChar, modifiers)) {
            return;
        }
        super.onKeyReleased(keyCode, typedChar, modifiers);
    }

    @EventSubscribe
    public void onWindowKeyPressed(@NotNull KeyPressedEvent event) {
        if (!event.getAction().equals((Object)KeyBinding.Action.UP)) {
            return;
        }
        if (this.m_6913_() && event.getKey().equals(KeyBinding.Type.KEYSYM.getOrCreate(UKeyboard.KEY_ESCAPE))) {
            this.m_7379_();
        }
    }

    @Override
    public void onDrawBackground(@NotNull UMatrixStack matrixStack, int tint) {
        super.onDrawBackground(matrixStack, tint);
    }

    public boolean m_6913_() {
        return this.screen.shouldCloseOnEsc();
    }

    public void m_7379_() {
        UMinecraft.getMinecraft().execute(() -> UScreen.displayScreen(null));
    }

    public void renderBackground(UMatrixStack stack) {
        super.onDrawBackground(stack, 0);
    }

    public void renderTooltip(UMatrixStack stack, List<MinecraftTextComponent> tooltip, int mouseX, int mouseY) {
        this.m_96597_(stack.toMC(), new ArrayList(RenderUtil.getTextConverter().convert(tooltip)), mouseX, mouseY);
    }

    public String toString() {
        return "ScreenWrapper(screen=" + this.getScreen() + ", ignoreFirstMove=" + this.ignoreFirstMove + ", lastDraggedMouseX=" + this.lastDraggedMouseX + ", lastDraggedMouseY=" + this.lastDraggedMouseY + ")";
    }

    public GuiScreen getScreen() {
        return this.screen;
    }
}

