/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.language;

import com.mojang.blaze3d.platform.InputConstants;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.voice.api.client.config.keybind.KeyBinding;

public final class LanguageUtil {
    public static String getOrDefault(String key) {
        return Language.m_128107_().m_6834_(key);
    }

    public static boolean has(String key) {
        return Language.m_128107_().m_6722_(key);
    }

    public static String getSelectedLanguage() {
        return Minecraft.m_91087_().m_91102_().m_264236_();
    }

    @NotNull
    public static MinecraftTextComponent getKeyDisplayName(@NonNull KeyBinding.Key key) {
        InputConstants.Key inputKey;
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (key.getType() == KeyBinding.Type.KEYSYM) {
            inputKey = InputConstants.Type.KEYSYM.m_84895_(key.getCode());
        } else if (key.getType() == KeyBinding.Type.MOUSE) {
            inputKey = InputConstants.Type.MOUSE.m_84895_(key.getCode());
        } else if (key.getType() == KeyBinding.Type.SCANCODE) {
            inputKey = InputConstants.Type.SCANCODE.m_84895_(key.getCode());
        } else {
            return MinecraftTextComponent.translatable("gui.none", new Object[0]);
        }
        Component displayName = inputKey.m_84875_();
        ComponentContents componentContents = displayName.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            return MinecraftTextComponent.translatable(translatable.m_237508_(), translatable.m_237523_());
        }
        componentContents = displayName.m_214077_();
        if (componentContents instanceof LiteralContents) {
            LiteralContents literal = (LiteralContents)componentContents;
            return MinecraftTextComponent.translatable(literal.f_237368_(), new Object[0]);
        }
        return MinecraftTextComponent.translatable("gui.none", new Object[0]);
    }

    private LanguageUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

